/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.manager;

import cn.ponfee.scheduler.common.base.IdGenerator;
import cn.ponfee.scheduler.common.base.LazyLoader;
import cn.ponfee.scheduler.common.base.tuple.Tuple3;
import cn.ponfee.scheduler.common.spring.MarkRpcController;
import cn.ponfee.scheduler.common.spring.TransactionUtils;
import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.JobState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RetryType;
import cn.ponfee.scheduler.core.enums.RunState;
import cn.ponfee.scheduler.core.enums.RunType;
import cn.ponfee.scheduler.core.enums.TriggerType;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedDepend;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.core.model.SchedTrack;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.base.WorkerServiceClient;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedDependMapper;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedJobMapper;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedTaskMapper;
import cn.ponfee.scheduler.supervisor.dao.mapper.SchedTrackMapper;
import cn.ponfee.scheduler.supervisor.manager.AbstractSupervisorManager;
import com.google.common.base.Joiner;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
public class SchedulerJobManager
extends AbstractSupervisorManager
implements SupervisorService,
MarkRpcController {
    private static final String TX_MANAGER_NAME = "schedulerTransactionManager";
    private static final int AFFECTED_ONE_ROW = 1;
    private static final String DEFAULT_USER = "0";
    private static final List<Integer> CANCELABLE_RUN_STATE_LIST = Collects.convert((List)RunState.CANCELABLE_LIST, RunState::value);
    private static final List<Integer> EXECUTABLE_EXECUTE_STATE_LIST = Collects.convert((List)ExecuteState.EXECUTABLE_LIST, ExecuteState::value);
    private final SchedJobMapper jobMapper;
    private final SchedTrackMapper trackMapper;
    private final SchedTaskMapper taskMapper;
    private final SchedDependMapper dependMapper;

    public SchedulerJobManager(IdGenerator idGenerator, SupervisorRegistry discoveryWorker, TaskDispatcher taskDispatcher, WorkerServiceClient workerServiceClient, SchedJobMapper jobMapper, SchedTrackMapper trackMapper, SchedTaskMapper taskMapper, SchedDependMapper dependMapper) {
        super(idGenerator, discoveryWorker, taskDispatcher, workerServiceClient);
        this.jobMapper = jobMapper;
        this.trackMapper = trackMapper;
        this.taskMapper = taskMapper;
        this.dependMapper = dependMapper;
    }

    public SchedJob getJob(long jobId) {
        return this.jobMapper.getByJobId(jobId);
    }

    public SchedTrack getTrack(long trackId) {
        return this.trackMapper.getByTrackId(trackId);
    }

    public SchedTask getTask(long taskId) {
        return this.taskMapper.getByTaskId(taskId);
    }

    public List<SchedTask> findMediumTaskByTrackId(long trackId) {
        return this.taskMapper.findMediumByTrackId(trackId);
    }

    public List<SchedTask> findLargeTaskByTrackId(long trackId) {
        return this.taskMapper.findLargeByTrackId(trackId);
    }

    public List<SchedJob> findBeTriggering(long maxNextTriggerTime, int size) {
        return this.jobMapper.findBeTriggering(maxNextTriggerTime, size);
    }

    public List<SchedTrack> findExpireWaiting(Date expireTime, int size) {
        return this.trackMapper.findExpireState(RunState.WAITING.value(), expireTime.getTime(), expireTime, size);
    }

    public List<SchedTrack> findExpireRunning(Date expireTime, int size) {
        return this.trackMapper.findExpireState(RunState.RUNNING.value(), expireTime.getTime(), expireTime, size);
    }

    public SchedTrack getByTriggerTime(long jobId, long triggerTime, int runType) {
        return this.trackMapper.getByTriggerTime(jobId, triggerTime, runType);
    }

    public List<SchedTrack> findUnterminatedRetry(long trackId) {
        return this.trackMapper.findUnterminatedRetry(trackId);
    }

    public boolean checkpoint(long taskId, String executeSnapshot) {
        return this.taskMapper.checkpoint(taskId, executeSnapshot) == 1;
    }

    public boolean renewUpdateTime(SchedTrack track, Date updateTime) {
        return this.trackMapper.renewUpdateTime(track.getTrackId(), updateTime, track.getVersion()) == 1;
    }

    public boolean changeJobState(long jobId, JobState to) {
        return this.jobMapper.updateState(jobId, to.value(), 1 ^ to.value()) == 1;
    }

    public boolean stopJob(SchedJob job) {
        return 1 == this.jobMapper.stop(job);
    }

    public boolean updateNextTriggerTime(SchedJob job) {
        return this.jobMapper.updateNextTriggerTime(job) == 1;
    }

    public boolean updateNextScanTime(long jobId, Date nextScanTime, int version) {
        return this.jobMapper.updateNextScanTime(jobId, nextScanTime, version) == 1;
    }

    public boolean updateTaskWorker(List<Long> taskIds, String worker) {
        if (StringUtils.isNotBlank((CharSequence)worker)) {
            try {
                Worker.deserialize((String)worker);
            }
            catch (Exception e) {
                this.log.error("Invalid worker serialized text: {}", (Object)worker);
                return false;
            }
        }
        return this.taskMapper.updateWorker(taskIds, worker) >= 1;
    }

    public boolean updateTaskErrorMsg(long taskId, String errorMsg) {
        try {
            return this.taskMapper.updateErrorMsg(taskId, errorMsg) == 1;
        }
        catch (Exception e) {
            this.log.error("Update sched task error msg failed: " + taskId, (Throwable)e);
            return false;
        }
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void addJob(SchedJob job) {
        Assert.notNull((Object)job.getTriggerType(), (String)"Trigger type cannot be null.");
        Assert.notNull((Object)job.getTriggerConf(), (String)"Trigger conf cannot be null.");
        Assert.isNull((Object)job.getLastTriggerTime(), (String)"Last trigger time must be null.");
        Assert.isNull((Object)job.getNextTriggerTime(), (String)"Next trigger time must be null.");
        super.verifyJobHandler(job);
        job.checkAndDefaultSetting();
        job.setJobId(Long.valueOf(this.generateId()));
        Date now = new Date();
        this.parseTriggerConfig(job, now);
        job.setCreatedAt(now);
        job.setUpdatedAt(now);
        job.setCreatedBy(DEFAULT_USER);
        job.setUpdatedBy(DEFAULT_USER);
        this.jobMapper.insert(job);
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void updateJob(SchedJob job) {
        Assert.notNull((Object)job.getJobId(), (String)"Job id cannot be null");
        Assert.notNull((Object)job.getVersion(), (String)"Version cannot be null");
        Assert.isNull((Object)job.getLastTriggerTime(), (String)"Last trigger time must be null");
        Assert.isNull((Object)job.getNextTriggerTime(), (String)"Next trigger time must be null.");
        if (StringUtils.isEmpty((CharSequence)job.getJobHandler())) {
            Assert.isTrue((boolean)StringUtils.isEmpty((CharSequence)job.getJobParam()), (String)"Job param must be null if not set job handler.");
        } else {
            super.verifyJobHandler(job);
        }
        job.checkAndDefaultSetting();
        SchedJob dbSchedJob = this.jobMapper.getByJobId(job.getJobId());
        Assert.notNull((Object)dbSchedJob, (String)("Sched job id not found " + job.getJobId()));
        job.setNextTriggerTime(dbSchedJob.getNextTriggerTime());
        Date now = new Date();
        if (job.getTriggerType() == null) {
            Assert.isNull((Object)job.getTriggerConf(), (String)"Trigger conf must be null if not set trigger type.");
        } else {
            Assert.notNull((Object)job.getTriggerConf(), (String)"Trigger conf cannot be null if has set trigger type.");
            this.dependMapper.deleteByChildJobId(job.getJobId());
            this.parseTriggerConfig(job, now);
        }
        job.setUpdatedAt(now);
        job.setUpdatedBy(DEFAULT_USER);
        Assert.state((this.jobMapper.updateByJobId(job) == 1 ? 1 : 0) != 0, (String)"Update sched job fail or conflict.");
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void deleteJob(long jobId) {
        Assert.isTrue((this.jobMapper.deleteByJobId(jobId) == 1 ? 1 : 0) != 0, (String)"Delete sched job fail or conflict.");
        this.dependMapper.deleteByParentJobId(jobId);
        this.dependMapper.deleteByChildJobId(jobId);
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void deleteTrack(long trackId) {
        SchedTrack track = this.trackMapper.getByTrackId(trackId);
        Assert.notNull((Object)track, (String)("Sched track not found: " + trackId));
        RunState runState = RunState.of((Integer)track.getRunState());
        Assert.isTrue((boolean)runState.isTerminal(), (String)("Cannot delete unterminated sched track: " + trackId + ", run state=" + runState));
        int row = this.trackMapper.deleteByTrackId(trackId);
        Assert.isTrue((row == 1 ? 1 : 0) != 0, (String)("Delete sched track conflict: " + trackId));
        this.taskMapper.deleteByTrackId(trackId);
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void forceUpdateState(long trackId, int trackTargetState, int taskTargetState) {
        ExecuteState taskTargetState0 = ExecuteState.of((Integer)taskTargetState);
        Assert.isTrue((taskTargetState0.runState() == RunState.of((Integer)trackTargetState) ? 1 : 0) != 0, (String)("Inconsistent state: " + trackTargetState + ", " + taskTargetState));
        int row = this.trackMapper.forceUpdateState(trackId, trackTargetState);
        Assert.isTrue((row == 1 ? 1 : 0) != 0, (String)("Sched track state update failed " + trackId));
        row = this.taskMapper.forceUpdateState(trackId, taskTargetState);
        Assert.isTrue((row >= 1 ? 1 : 0) != 0, (String)("Sched task state update failed, track_id=" + trackId));
        if (taskTargetState0 == ExecuteState.WAITING) {
            Tuple3<SchedJob, SchedTrack, List<SchedTask>> params = this.buildDispatchParams(trackId, row);
            TransactionUtils.doAfterTransactionCommit(() -> super.dispatch((SchedJob)params.a, (SchedTrack)params.b, (List)params.c));
        }
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public void trigger(long jobId) throws JobException {
        SchedJob job = this.jobMapper.getByJobId(jobId);
        Assert.notNull((Object)job, (String)("Sched job not found: " + jobId));
        Date now = new Date();
        SchedTrack track = SchedTrack.create((long)this.generateId(), (long)job.getJobId(), (RunType)RunType.MANUAL, (long)now.getTime(), (int)0, (Date)now);
        List<SchedTask> tasks = this.splitTasks(job, track.getTrackId(), now);
        int row = this.trackMapper.insert(track);
        Assert.state((row == 1 ? 1 : 0) != 0, (String)("Insert sched track fail: " + track));
        row = this.taskMapper.insertBatch(tasks);
        Assert.state((row == tasks.size() ? 1 : 0) != 0, (String)("Insert sched task fail: " + tasks));
        TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(job, track, tasks));
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean updateAndSave(SchedJob job, SchedTrack track, List<SchedTask> tasks) {
        int row = this.jobMapper.updateNextTriggerTime(job);
        if (row == 0) {
            return false;
        }
        row = this.trackMapper.insert(track);
        Assert.state((row == 1 ? 1 : 0) != 0, (String)("Insert sched track fail: " + track));
        Assert.notEmpty(tasks, (String)"Insert list of task cannot be empty.");
        row = this.taskMapper.insertBatch(tasks);
        Assert.state((row == tasks.size() ? 1 : 0) != 0, (String)("Insert sched task fail: " + tasks));
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean startTask(ExecuteParam param) {
        Integer state = this.trackMapper.getStateByTrackId(param.getTrackId());
        Assert.state((state != null ? 1 : 0) != 0, (String)("Sched track not found: " + param));
        RunState runState = RunState.of((Integer)state);
        Assert.state((boolean)RunState.PAUSABLE_LIST.contains(runState), (String)("Start track failed: " + param + ", " + runState));
        Date now = new Date();
        int trackRow = this.trackMapper.start(param.getTrackId(), now);
        int taskRow = this.taskMapper.start(param.getTaskId(), param.getWorker().toString(), now);
        if (trackRow == 0 && taskRow == 0) {
            return false;
        }
        Assert.state((taskRow == 1 ? 1 : 0) != 0, (String)("Start task failed: " + param));
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean terminateExecutingTask(ExecuteParam param, ExecuteState toState, String errorMsg) {
        boolean result;
        Integer state = this.trackMapper.lockAndGetState(param.getTrackId());
        Assert.notNull((Object)state, (String)("Terminate failed, track_id not found: " + param.getTrackId()));
        if (RunState.of((Integer)state).isTerminal()) {
            return false;
        }
        int row = this.taskMapper.terminate(param.getTaskId(), toState.value(), ExecuteState.EXECUTING.value(), new Date(), errorMsg);
        boolean bl = result = row == 1;
        if (!result) {
            this.log.warn("Conflict terminate task {}, {}", (Object)param.getTaskId(), (Object)toState);
        }
        this.terminate(param.getTrackId(), false);
        return result;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean terminate(long trackId) {
        Integer state = this.trackMapper.lockAndGetState(trackId);
        Assert.notNull((Object)state, (String)("Terminate failed, track_id not found: " + trackId));
        if (RunState.of((Integer)state).isTerminal()) {
            return false;
        }
        return this.terminate(trackId, true);
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean pauseTrack(long trackId) {
        Integer state = this.trackMapper.lockAndGetState(trackId);
        Assert.notNull((Object)state, (String)("Pause failed, track_id not found: " + trackId));
        RunState runState = RunState.of((Integer)state);
        if (!RunState.PAUSABLE_LIST.contains(runState)) {
            return false;
        }
        this.taskMapper.updateStateByTrackId(trackId, ExecuteState.PAUSED.value(), Collections.singletonList(ExecuteState.WAITING.value()), null);
        List<ExecuteParam> executingTasks = this.loadExecutingTasks(trackId, Operations.PAUSE);
        if (executingTasks.isEmpty()) {
            List stateList = this.taskMapper.findMediumByTrackId(trackId).stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).collect(Collectors.toList());
            RunState toRunState = stateList.stream().anyMatch(arg_0 -> ((ExecuteState)ExecuteState.PAUSED).equals(arg_0)) ? RunState.PAUSED : (stateList.stream().anyMatch(ExecuteState::isFailure) ? RunState.CANCELED : RunState.FINISHED);
            int row = toRunState.isTerminal() ? this.trackMapper.terminate(trackId, toRunState.value(), Collections.singletonList(runState.value()), new Date()) : this.trackMapper.updateState(trackId, toRunState.value(), runState.value(), null);
            if (row != 1) {
                this.log.warn("Pause track from {} to {} conflict", (Object)runState, (Object)toRunState);
            }
        } else {
            TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(executingTasks));
        }
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean pauseExecutingTask(ExecuteParam param, String errorMsg) {
        Integer state = this.trackMapper.lockAndGetState(param.getTrackId());
        if (!RunState.RUNNING.equals(state)) {
            this.log.warn("Pause executing task failed: {} | {}", (Object)param, (Object)state);
            return false;
        }
        int row = this.taskMapper.updateState(param.getTaskId(), ExecuteState.PAUSED.value(), ExecuteState.EXECUTING.value(), errorMsg, null);
        if (row != 1) {
            this.log.warn("Paused task unsuccessful.");
            return false;
        }
        boolean allPaused = this.taskMapper.findMediumByTrackId(param.getTrackId()).stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).noneMatch(ExecuteState.PAUSABLE_LIST::contains);
        if (allPaused && (row = this.trackMapper.updateState(param.getTrackId(), RunState.PAUSED.value(), RunState.RUNNING.value(), null)) != 1) {
            this.log.error("Update sched track to paused state conflict: {} | {}", (Object)param.getTrackId(), (Object)param.getTaskId());
        }
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean cancelTrack(long trackId, Operations operation) {
        Assert.isTrue((boolean)operation.targetState().isFailure(), (String)("Expect cancel ops, but actual: " + operation));
        Integer state = this.trackMapper.lockAndGetState(trackId);
        Assert.notNull((Object)state, (String)("Cancel failed, track_id not found: " + trackId));
        RunState runState = RunState.of((Integer)state);
        if (runState.isTerminal()) {
            return false;
        }
        this.taskMapper.updateStateByTrackId(trackId, operation.targetState().value(), EXECUTABLE_EXECUTE_STATE_LIST, new Date());
        List<ExecuteParam> executingTasks = this.loadExecutingTasks(trackId, operation);
        if (executingTasks.isEmpty()) {
            boolean failure = this.taskMapper.findMediumByTrackId(trackId).stream().anyMatch(e -> ExecuteState.of((Integer)e.getExecuteState()).isFailure());
            RunState toRunState = failure ? RunState.CANCELED : RunState.FINISHED;
            int row = this.trackMapper.terminate(trackId, toRunState.value(), Collections.singletonList(runState.value()), new Date());
            if (row != 1) {
                this.log.warn("Pause track from {} to {} conflict", (Object)runState, (Object)toRunState);
            }
        } else {
            TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(executingTasks));
        }
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean cancelExecutingTask(ExecuteParam param, ExecuteState toState, String errorMsg) {
        Assert.isTrue((boolean)toState.isFailure(), (String)("Target state expect failure state, but actual: " + toState));
        Integer state = this.trackMapper.lockAndGetState(param.getTrackId());
        if (!RunState.RUNNING.equals(state)) {
            return false;
        }
        int row = this.taskMapper.terminate(param.getTaskId(), toState.value(), ExecuteState.EXECUTING.value(), new Date(), errorMsg);
        if (row != 1) {
            this.log.warn("Canceled task unsuccessful.");
            return false;
        }
        boolean allTerminated = this.taskMapper.findMediumByTrackId(param.getTrackId()).stream().map(e -> ExecuteState.of((Integer)e.getExecuteState())).allMatch(ExecuteState::isTerminal);
        if (allTerminated && (row = this.trackMapper.terminate(param.getTrackId(), RunState.CANCELED.value(), Collections.singletonList(RunState.RUNNING.value()), new Date())) != 1) {
            this.log.error("Update sched track to canceled state conflict: {} | {}", (Object)param.getTrackId(), (Object)param.getTaskId());
        }
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean resume(long trackId) {
        Integer state = this.trackMapper.lockAndGetState(trackId);
        Assert.notNull((Object)state, (String)("Cancel failed, track_id not found: " + trackId));
        if (!RunState.PAUSED.equals(state)) {
            return false;
        }
        int row = this.trackMapper.updateState(trackId, RunState.WAITING.value(), RunState.PAUSED.value(), null);
        Assert.state((row == 1 ? 1 : 0) != 0, (String)"Resume sched track failed.");
        row = this.taskMapper.updateStateByTrackId(trackId, ExecuteState.WAITING.value(), Collections.singletonList(ExecuteState.PAUSED.value()), null);
        Assert.state((row >= 1 ? 1 : 0) != 0, (String)"Resume sched task failed.");
        Tuple3<SchedJob, SchedTrack, List<SchedTask>> params = this.buildDispatchParams(trackId, row);
        TransactionUtils.doAfterTransactionCommit(() -> super.dispatch((SchedJob)params.a, (SchedTrack)params.b, (List)params.c));
        return true;
    }

    @Transactional(transactionManager="schedulerTransactionManager", rollbackFor={Exception.class})
    public boolean updateState(ExecuteState toState, List<SchedTask> tasks, SchedTrack track) {
        if (this.trackMapper.lockAndGetId(track.getTrackId()) == null) {
            return false;
        }
        int row = this.trackMapper.updateState(track.getTrackId(), toState.runState().value(), track.getRunState(), track.getVersion());
        if (row != 1) {
            this.log.warn("Conflict update track run state: {} | {}", (Object)track, (Object)toState.runState());
            return false;
        }
        row = 0;
        for (SchedTask task : tasks) {
            row += this.taskMapper.updateState(task.getTaskId(), toState.value(), task.getExecuteState(), null, task.getVersion());
        }
        Assert.state((row >= 1 ? 1 : 0) != 0, (String)("Conflict update state: " + toState + ", " + tasks + ", " + track));
        return true;
    }

    private boolean terminate(long trackId, boolean force) {
        RunState runState;
        Date runEndTime;
        List<SchedTask> tasks = this.taskMapper.findMediumByTrackId(trackId);
        if (CollectionUtils.isEmpty(tasks)) {
            this.log.error("Not found sched track task data {}", (Object)trackId);
            return false;
        }
        List taskStateList = tasks.stream().map(SchedTask::getExecuteState).map(ExecuteState::of).collect(Collectors.toList());
        if (taskStateList.stream().allMatch(ExecuteState::isTerminal)) {
            runEndTime = tasks.stream().map(SchedTask::getExecuteEndTime).max(Comparator.naturalOrder()).orElseThrow(IllegalStateException::new);
            runState = taskStateList.stream().allMatch(arg_0 -> ((ExecuteState)ExecuteState.FINISHED).equals(arg_0)) ? RunState.FINISHED : RunState.CANCELED;
        } else if (force) {
            runEndTime = new Date();
            runState = RunState.CANCELED;
        } else {
            return false;
        }
        int row = this.trackMapper.terminate(trackId, runState.value(), CANCELABLE_RUN_STATE_LIST, runEndTime);
        if (row != 1) {
            return false;
        }
        if (force) {
            tasks.stream().filter(e -> !ExecuteState.of((Integer)e.getExecuteState()).isTerminal()).forEach(e -> {
                int affectedRow = this.taskMapper.terminate(e.getTaskId(), ExecuteState.EXECUTE_TIMEOUT.value(), e.getExecuteState(), new Date(), null);
                Assert.state((affectedRow == 1 ? 1 : 0) != 0, (String)("Terminate task state conflict " + e));
            });
        }
        if (runState == RunState.CANCELED) {
            this.retryJob(trackId);
        } else if (runState == RunState.FINISHED) {
            this.dependJob(trackId);
        } else {
            this.log.error("Unknown retry run state " + runState);
        }
        return true;
    }

    private void retryJob(long trackId) {
        List<Object> tasks;
        SchedTrack prevTrack = this.trackMapper.getByTrackId(trackId);
        SchedJob schedJob = this.jobMapper.getByJobId(prevTrack.getJobId());
        if (schedJob == null) {
            this.log.error("Sched job not found {}", (Object)prevTrack.getJobId());
            return;
        }
        List<SchedTask> prevTasks = this.taskMapper.findLargeByTrackId(trackId);
        RetryType retryType = RetryType.of((Integer)schedJob.getRetryType());
        if (retryType == RetryType.NONE || schedJob.getRetryCount() < 1) {
            return;
        }
        int retriedCount = Optional.ofNullable(prevTrack.getRetriedCount()).orElse(0);
        if (retriedCount >= schedJob.getRetryCount()) {
            return;
        }
        Date now = new Date();
        long triggerTime = SchedulerJobManager.computeRetryTriggerTime(schedJob, ++retriedCount, now);
        SchedTrack retryTrack = SchedTrack.create((long)this.generateId(), (long)schedJob.getJobId(), (RunType)RunType.RETRY, (long)triggerTime, (int)retriedCount, (Date)now);
        retryTrack.setParentTrackId(RunType.RETRY.equals(prevTrack.getRunType()) ? prevTrack.getParentTrackId() : prevTrack.getTrackId());
        switch (retryType) {
            case ALL: {
                try {
                    tasks = this.splitTasks(schedJob, retryTrack.getTrackId(), now);
                    break;
                }
                catch (Exception e2) {
                    this.log.error("Split job error: " + schedJob + ", " + prevTrack, (Throwable)e2);
                    return;
                }
            }
            case FAILED: {
                tasks = prevTasks.stream().filter(e -> ExecuteState.of((Integer)e.getExecuteState()).isFailure()).map(e -> SchedTask.create((String)e.getTaskParam(), (long)this.generateId(), (long)retryTrack.getTrackId(), (Date)now)).collect(Collectors.toList());
                break;
            }
            default: {
                this.log.error("Job unsupported retry type {}", (Object)schedJob);
                return;
            }
        }
        Assert.notEmpty(tasks, (String)"Insert list of task cannot be empty.");
        this.trackMapper.insert(retryTrack);
        this.taskMapper.insertBatch(tasks);
        TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(schedJob, retryTrack, tasks));
    }

    private void dependJob(long trackId) {
        SchedTrack parentTrack = this.trackMapper.getByTrackId(trackId);
        List<SchedDepend> schedDepends = this.dependMapper.findByParentJobId(parentTrack.getJobId());
        if (CollectionUtils.isEmpty(schedDepends)) {
            return;
        }
        for (SchedDepend depend : schedDepends) {
            SchedJob childJob = this.jobMapper.getByJobId(depend.getChildJobId());
            if (childJob == null) {
                this.log.error("Child sched job not found {}, {}", (Object)depend.getParentJobId(), (Object)depend.getChildJobId());
                return;
            }
            if (JobState.DISABLE.equals(childJob.getJobState())) {
                return;
            }
            try {
                Date now = new Date();
                SchedTrack track = SchedTrack.create((long)this.generateId(), (long)childJob.getJobId(), (RunType)RunType.DEPEND, (long)parentTrack.getTriggerTime(), (int)0, (Date)now);
                track.setParentTrackId(parentTrack.getTrackId());
                List<SchedTask> tasks = this.splitTasks(childJob, track.getTrackId(), now);
                this.trackMapper.insert(track);
                this.taskMapper.insertBatch(tasks);
                TransactionUtils.doAfterTransactionCommit(() -> super.dispatch(childJob, track, tasks));
            }
            catch (Exception e) {
                this.log.error("Depend job split failed: " + childJob, (Throwable)e);
            }
        }
    }

    private List<ExecuteParam> loadExecutingTasks(long trackId, Operations ops) {
        SchedTrack schedTrackProxy = (SchedTrack)LazyLoader.of(SchedTrack.class, this.trackMapper::getByTrackId, (Object)trackId);
        ArrayList<ExecuteParam> executingTasks = new ArrayList<ExecuteParam>();
        this.taskMapper.findMediumByTrackId(trackId).stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).forEach(task -> {
            Worker worker = Worker.deserialize((String)task.getWorker());
            if (super.isAliveWorker(worker)) {
                ExecuteParam param = new ExecuteParam(ops, task.getTaskId().longValue(), trackId, schedTrackProxy.getJobId().longValue(), 0L);
                param.setWorker(worker);
                executingTasks.add(param);
            } else {
                this.log.info("Cancel the dead task {}", task);
                this.taskMapper.updateState(task.getTaskId(), ops.targetState().value(), ExecuteState.EXECUTING.value(), null, null);
            }
        });
        return executingTasks;
    }

    private Tuple3<SchedJob, SchedTrack, List<SchedTask>> buildDispatchParams(long trackId, int expectTaskSize) {
        SchedTrack track = this.trackMapper.getByTrackId(trackId);
        SchedJob job = this.jobMapper.getByJobId(track.getJobId());
        List waitingTasks = this.taskMapper.findLargeByTrackId(trackId).stream().filter(e -> ExecuteState.WAITING.equals(e.getExecuteState())).collect(Collectors.toList());
        Assert.isTrue((waitingTasks.size() == expectTaskSize ? 1 : 0) != 0, (String)("Dispatching tasks size inconsistent, expect=" + expectTaskSize + ", actual=" + waitingTasks.size()));
        return Tuple3.of((Object)job, (Object)track, waitingTasks);
    }

    private void parseTriggerConfig(SchedJob job, Date date) {
        TriggerType triggerType = TriggerType.of((Integer)job.getTriggerType());
        Assert.isTrue((boolean)triggerType.isValid(job.getTriggerConf()), (String)("Invalid trigger config: " + job.getTriggerType() + ", " + job.getTriggerConf()));
        if (triggerType == TriggerType.DEPEND) {
            List<Long> parentJobIds = Arrays.stream(job.getTriggerConf().split(",")).filter(StringUtils::isNotBlank).map(e -> Long.parseLong(e.trim())).distinct().collect(Collectors.toList());
            Assert.isTrue((!parentJobIds.isEmpty() && this.jobMapper.countJobIds(parentJobIds) == parentJobIds.size() ? 1 : 0) != 0, (String)("Has parent job id not found " + job.getTriggerConf()));
            this.dependMapper.insertBatch(parentJobIds.stream().map(e -> new SchedDepend(e, job.getJobId())).collect(Collectors.toList()));
            job.setTriggerConf(Joiner.on((String)",").join(parentJobIds));
            job.setNextTriggerTime(null);
        } else {
            Date nextTriggerTime = triggerType.computeNextFireTime(job.getTriggerConf(), date);
            Assert.notNull((Object)nextTriggerTime, (String)("Has not next trigger time " + job.getTriggerConf()));
            job.setNextTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
        }
    }

    private static long computeRetryTriggerTime(SchedJob job, int failCount, Date current) {
        Assert.isTrue((!RetryType.NONE.equals(job.getRetryType()) ? 1 : 0) != 0, (String)("Sched job '" + job.getJobId() + "' retry type is NONE."));
        Assert.isTrue((job.getRetryCount() > 0 ? 1 : 0) != 0, (String)("Sched job '" + job.getJobId() + "' retry count must greater than 0, but actual " + job.getRetryCount()));
        Assert.isTrue((failCount <= job.getRetryCount() ? 1 : 0) != 0, (String)("Sched job '" + job.getJobId() + "' retried " + failCount + " exceed " + job.getRetryCount() + " limit."));
        return current.getTime() + (long)job.getRetryInterval().intValue() * (long)IntMath.pow((int)failCount, (int)2);
    }
}

