/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.thread;

import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.core.base.AbstractHeartbeatThread;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.core.model.SchedTrack;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ScanRunningTrackThread
extends AbstractHeartbeatThread {
    private final DoInLocked doInLocked;
    private final SchedulerJobManager schedulerJobManager;
    private final long beforeMilliseconds;

    public ScanRunningTrackThread(long heartbeatPeriodMs0, DoInLocked doInLocked, SchedulerJobManager schedulerJobManager) {
        super(heartbeatPeriodMs0);
        this.doInLocked = doInLocked;
        this.schedulerJobManager = schedulerJobManager;
        this.beforeMilliseconds = this.heartbeatPeriodMs << 2;
    }

    protected boolean heartbeat() {
        if (this.schedulerJobManager.hasNotFoundWorkers()) {
            this.log.warn("Not found available worker.");
            return true;
        }
        Boolean result = (Boolean)this.doInLocked.apply(this::process);
        return result == null || result != false;
    }

    private boolean process() {
        Date now = new Date();
        Date expireTime = new Date(now.getTime() - this.beforeMilliseconds);
        List<SchedTrack> tracks = this.schedulerJobManager.findExpireRunning(expireTime, 200);
        if (CollectionUtils.isEmpty(tracks)) {
            return true;
        }
        for (SchedTrack track : tracks) {
            this.processEach(track, now);
        }
        return tracks.size() < 200;
    }

    private void processEach(SchedTrack track, Date now) {
        List<SchedTask> tasks = this.schedulerJobManager.findMediumTaskByTrackId(track.getTrackId());
        List<SchedTask> waitingTasks = tasks.stream().filter(e -> ExecuteState.WAITING.equals(e.getExecuteState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(waitingTasks)) {
            List<SchedTask> dispatchingTasks;
            boolean isUpdateSuccess = this.schedulerJobManager.renewUpdateTime(track, now);
            if (isUpdateSuccess && CollectionUtils.isNotEmpty(dispatchingTasks = this.schedulerJobManager.filterDispatchingTask(waitingTasks))) {
                this.log.info("Redispatch sched track: {} | {}", (Object)track, (Object)Jsons.toJson(dispatchingTasks));
                SchedJob schedJob = this.schedulerJobManager.getJob(track.getJobId());
                this.schedulerJobManager.dispatch(schedJob, track, dispatchingTasks);
            }
            return;
        }
        if (this.schedulerJobManager.hasAliveExecuting(tasks)) {
            this.schedulerJobManager.renewUpdateTime(track, now);
            return;
        }
        this.log.info("Scan track, all worker dead, terminate the sched track: {}", (Object)track.getTrackId());
        this.schedulerJobManager.terminate(track.getTrackId());
    }
}

