/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.configuration;

import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.SupervisorStartup;
import cn.ponfee.scheduler.supervisor.configuration.SupervisorProperties;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;

@AutoConfigureOrder(value=0x7FFFFFFF)
public class SupervisorStartupRunner
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorStartupRunner.class);
    private final SupervisorStartup supervisorStartup;

    public SupervisorStartupRunner(Supervisor currentSupervisor, SupervisorProperties supervisorConfig, SchedulerJobManager schedulerJobManager, @Qualifier(value="scan-triggering-job-locker") DoInLocked scanTriggeringJobLocker, @Qualifier(value="scan-waiting-instance-locker") DoInLocked scanWaitingInstanceLocker, @Qualifier(value="scan-running-instance-locker") DoInLocked scanRunningInstanceLocker, SupervisorRegistry supervisorRegistry, TaskDispatcher taskDispatcher) {
        this.supervisorStartup = SupervisorStartup.builder().currentSupervisor(currentSupervisor).supervisorConfig(supervisorConfig).supervisorRegistry(supervisorRegistry).schedulerJobManager(schedulerJobManager).scanTriggeringJobLocker(scanTriggeringJobLocker).scanWaitingInstanceLocker(scanWaitingInstanceLocker).scanRunningInstanceLocker(scanRunningInstanceLocker).taskDispatcher(taskDispatcher).build();
    }

    public void run(ApplicationArguments args) {
        LOG.info("Scheduler supervisor launch begin...");
        this.supervisorStartup.start();
        LOG.info("Scheduler supervisor launch end.");
    }

    public void destroy() {
        LOG.info("Scheduler supervisor stop begin...");
        this.supervisorStartup.close();
        LOG.info("Scheduler supervisor stop end.");
    }
}

