/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.manager;

import cn.ponfee.scheduler.common.base.IdGenerator;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.handle.SplitTask;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskDispatcher;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.supervisor.base.WorkerServiceClient;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractSupervisorManager {
    private static final int MAX_SPLIT_TASK_SIZE = 1000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IdGenerator idGenerator;
    private final SupervisorRegistry discoveryWorker;
    private final TaskDispatcher taskDispatcher;
    private final WorkerServiceClient workerServiceClient;

    public long generateId() {
        return this.idGenerator.generateId();
    }

    public void verifyJobHandler(SchedJob job) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)job.getJobHandler()), (String)"Job handler cannot be empty.");
        Assert.isTrue((boolean)this.workerServiceClient.verify(job.getJobGroup(), job.getJobHandler(), job.getJobParam()), () -> "Invalid job handler: " + job.getJobHandler());
    }

    public List<SchedTask> splitTasks(SchedJob job, long instanceId, Date date) throws JobException {
        List<SplitTask> split = this.workerServiceClient.split(job.getJobGroup(), job.getJobHandler(), job.getJobParam());
        Assert.notEmpty(split, () -> "Not split any task: " + job);
        Assert.isTrue((split.size() <= 1000 ? 1 : 0) != 0, () -> "Split task size must less than 1000, job=" + job);
        return split.stream().map(e -> SchedTask.create((String)e.getTaskParam(), (long)this.generateId(), (long)instanceId, (Date)date)).collect(Collectors.toList());
    }

    public List<SchedTask> filterDispatchingTask(List<SchedTask> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return Collections.emptyList();
        }
        return tasks.stream().filter(e -> ExecuteState.WAITING.equals(e.getExecuteState())).filter(e -> !this.isAliveWorker(e.getWorker())).collect(Collectors.toList());
    }

    public boolean hasAliveExecuting(List<SchedTask> tasks) {
        Assert.notEmpty(tasks, (String)"Task list cannot be empty.");
        return tasks.stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).map(SchedTask::getWorker).anyMatch(this::isAliveWorker);
    }

    public boolean isAliveWorker(String text) {
        return StringUtils.isNotBlank((CharSequence)text) && this.isAliveWorker(Worker.deserialize((String)text));
    }

    public boolean isAliveWorker(Worker worker) {
        return worker != null && this.discoveryWorker.isDiscoveredServer((Server)worker);
    }

    public boolean hasNotDiscoveredWorkers(String group) {
        return CollectionUtils.isEmpty((Collection)this.discoveryWorker.getDiscoveredServers(group));
    }

    public boolean hasNotDiscoveredWorkers() {
        return !this.discoveryWorker.hasDiscoveredServers();
    }

    public boolean dispatch(SchedJob job, SchedInstance instance, List<SchedTask> tasks) {
        return this.taskDispatcher.dispatch(job, instance, tasks);
    }

    public boolean dispatch(List<ExecuteParam> tasks) {
        return this.taskDispatcher.dispatch(tasks);
    }

    public AbstractSupervisorManager(IdGenerator idGenerator, SupervisorRegistry discoveryWorker, TaskDispatcher taskDispatcher, WorkerServiceClient workerServiceClient) {
        this.idGenerator = idGenerator;
        this.discoveryWorker = discoveryWorker;
        this.taskDispatcher = taskDispatcher;
        this.workerServiceClient = workerServiceClient;
    }
}

