/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.thread;

import cn.ponfee.scheduler.common.date.Dates;
import cn.ponfee.scheduler.common.lock.DoInLocked;
import cn.ponfee.scheduler.core.base.AbstractHeartbeatThread;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.model.SchedInstance;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.core.model.SchedTask;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class WaitingInstanceScanner
extends AbstractHeartbeatThread {
    private final DoInLocked doInLocked;
    private final SchedulerJobManager schedulerJobManager;
    private final long beforeMilliseconds;

    public WaitingInstanceScanner(long heartbeatPeriodMs0, DoInLocked doInLocked, SchedulerJobManager schedulerJobManager) {
        super(heartbeatPeriodMs0);
        this.doInLocked = doInLocked;
        this.schedulerJobManager = schedulerJobManager;
        this.beforeMilliseconds = this.heartbeatPeriodMs << 3;
    }

    protected boolean heartbeat() {
        if (this.schedulerJobManager.hasNotDiscoveredWorkers()) {
            this.log.warn("Not found available worker.");
            return true;
        }
        Boolean result = (Boolean)this.doInLocked.apply(this::process);
        return result == null || result != false;
    }

    private boolean process() {
        Date now = new Date();
        Date expireTime = new Date(now.getTime() - this.beforeMilliseconds);
        List<SchedInstance> instances = this.schedulerJobManager.findExpireWaiting(expireTime, 200);
        if (CollectionUtils.isEmpty(instances)) {
            return true;
        }
        for (SchedInstance instance : instances) {
            this.processEach(instance, now);
        }
        return instances.size() < 200;
    }

    private void processEach(SchedInstance instance, Date now) {
        List<SchedTask> tasks = this.schedulerJobManager.findMediumTaskByInstanceId(instance.getInstanceId());
        if (tasks.stream().allMatch(t -> ExecuteState.of((Integer)t.getExecuteState()).isTerminal())) {
            if (this.schedulerJobManager.renewUpdateTime(instance, now)) {
                this.log.info("All task terminal, terminate the sched instance: {}", (Object)instance.getInstanceId());
                this.schedulerJobManager.terminate(instance.getInstanceId());
            }
            return;
        }
        List<SchedTask> waitingTasks = tasks.stream().filter(e -> ExecuteState.WAITING.equals(e.getExecuteState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(waitingTasks)) {
            this.log.info("Not has waiting tasks: {}", (Object)instance);
            return;
        }
        List<SchedTask> dispatchingTasks = this.schedulerJobManager.filterDispatchingTask(waitingTasks);
        if (CollectionUtils.isEmpty(dispatchingTasks)) {
            this.schedulerJobManager.renewUpdateTime(instance, now);
            return;
        }
        SchedJob job = this.schedulerJobManager.getJob(instance.getJobId());
        if (job == null) {
            this.log.error("Job not exists: {}, {}", (Object)instance, tasks);
            this.schedulerJobManager.updateState(ExecuteState.DATA_INCONSISTENT, tasks, instance);
            return;
        }
        if (this.schedulerJobManager.hasNotDiscoveredWorkers(job.getJobGroup())) {
            this.schedulerJobManager.renewUpdateTime(instance, now);
            this.log.warn("Scan instance not found available group '{}' workers.", (Object)job.getJobGroup());
            return;
        }
        if (this.schedulerJobManager.renewUpdateTime(instance, now)) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Redispatch sched instance: {} | {}", (Object)instance, (Object)Dates.format((Date)now));
            }
            this.schedulerJobManager.dispatch(job, instance, dispatchingTasks);
        }
    }
}

