/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.supervisor.web.controller;

import cn.ponfee.scheduler.common.base.model.Result;
import cn.ponfee.scheduler.core.enums.ExecuteState;
import cn.ponfee.scheduler.core.enums.JobState;
import cn.ponfee.scheduler.core.enums.Operations;
import cn.ponfee.scheduler.core.enums.RunState;
import cn.ponfee.scheduler.core.exception.JobException;
import cn.ponfee.scheduler.core.model.SchedJob;
import cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager;
import cn.ponfee.scheduler.supervisor.web.request.AddSchedJobRequest;
import cn.ponfee.scheduler.supervisor.web.request.UpdateSchedJobRequest;
import cn.ponfee.scheduler.supervisor.web.response.GetInstanceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api"})
public class ApiController {
    private static final Logger LOG = LoggerFactory.getLogger(ApiController.class);
    private final SchedulerJobManager schedulerJobManager;

    public ApiController(SchedulerJobManager schedulerJobManager) {
        this.schedulerJobManager = schedulerJobManager;
    }

    @PostMapping(value={"job/add"})
    public Result<Void> addJob(@RequestBody AddSchedJobRequest req) {
        this.schedulerJobManager.addJob(req.tosSchedJob());
        return Result.success();
    }

    @PutMapping(value={"job/update"})
    public Result<Void> updateJob(@RequestBody UpdateSchedJobRequest req) {
        LOG.info("Do updating sched job {}", (Object)req.getJobId());
        this.schedulerJobManager.updateJob(req.tosSchedJob());
        return Result.success();
    }

    @DeleteMapping(value={"job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do deleting sched job {}", (Object)jobId);
        this.schedulerJobManager.deleteJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"job/get"})
    public Result<SchedJob> getJob(@RequestParam(value="jobId") long jobId) {
        return Result.success((Object)this.schedulerJobManager.getJob(jobId));
    }

    @PostMapping(value={"job/disable"})
    public Result<Boolean> disableJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do disable sched job {}", (Object)jobId);
        return Result.success((Object)this.schedulerJobManager.changeJobState(jobId, JobState.DISABLE));
    }

    @PostMapping(value={"job/enable"})
    public Result<Boolean> enableJob(@RequestParam(value="jobId") long jobId) {
        LOG.info("Do enable sched job {}", (Object)jobId);
        return Result.success((Object)this.schedulerJobManager.changeJobState(jobId, JobState.ENABLE));
    }

    @PostMapping(value={"job/trigger"})
    public Result<Void> triggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        LOG.info("Do manual trigger the sched job {}", (Object)jobId);
        this.schedulerJobManager.trigger(jobId);
        return Result.success();
    }

    @PostMapping(value={"instance/pause"})
    public Result<Boolean> pauseInstance(@RequestParam(value="instanceId") long instanceId) {
        LOG.info("Do pausing sched instance {}", (Object)instanceId);
        return Result.success((Object)this.schedulerJobManager.pauseInstance(instanceId));
    }

    @PostMapping(value={"instance/cancel"})
    public Result<Boolean> cancelInstance(@RequestParam(value="instanceId") long instanceId) {
        LOG.info("Do canceling sched instance {}", (Object)instanceId);
        return Result.success((Object)this.schedulerJobManager.cancelInstance(instanceId, Operations.MANUAL_CANCEL));
    }

    @PostMapping(value={"instance/resume"})
    public Result<Boolean> resumeInstance(@RequestParam(value="instanceId") long instanceId) {
        LOG.info("Do resuming sched instance {}", (Object)instanceId);
        return Result.success((Object)this.schedulerJobManager.resume(instanceId));
    }

    @PostMapping(value={"instance/fresume"})
    public Result<Void> forceResumeInstance(@RequestParam(value="instanceId") long instanceId) {
        LOG.info("Do force resuming sched instance {}", (Object)instanceId);
        this.schedulerJobManager.forceUpdateState(instanceId, RunState.WAITING.value(), ExecuteState.WAITING.value());
        return Result.success();
    }

    @PutMapping(value={"instance/fupdate_state"})
    public Result<Void> forceUpdateInstanceState(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="instanceTargetState") int instanceTargetState, @RequestParam(value="taskTargetState") int taskTargetState) {
        RunState.of((Integer)instanceTargetState);
        ExecuteState.of((Integer)taskTargetState);
        LOG.info("Do force update sched instance state {} | {} | {}", new Object[]{instanceId, instanceTargetState, taskTargetState});
        this.schedulerJobManager.forceUpdateState(instanceId, instanceTargetState, taskTargetState);
        return Result.success();
    }

    @DeleteMapping(value={"instance/delete"})
    public Result<Void> deleteInstance(@RequestParam(value="instanceId") long instanceId) {
        LOG.info("Do deleting sched instance {}", (Object)instanceId);
        this.schedulerJobManager.deleteInstance(instanceId);
        return Result.success();
    }

    @GetMapping(value={"instance/get"})
    public Result<GetInstanceResponse> getInstance(@RequestParam(value="instanceId") long instanceId) {
        GetInstanceResponse response = new GetInstanceResponse(this.schedulerJobManager.getInstance(instanceId), this.schedulerJobManager.findLargeTaskByInstanceId(instanceId));
        return Result.success((Object)response);
    }
}

