/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.test.db;

import cn.ponfee.scheduler.common.util.Files;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.common.util.MavenProjects;
import cn.ponfee.scheduler.test.db.DBUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.h2.server.TcpServer;
import org.h2.tools.RunScript;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class EmbeddedH2DatabaseServer {
    public static void main(String[] args) throws Exception {
        String jdbcUrl = EmbeddedH2DatabaseServer.buildJdbcUrl("test");
        String username = "sa";
        String password = "";
        System.out.println("Embedded h2 database starting...");
        new TcpServer().start();
        System.out.println("Embedded h2 database started!");
        JdbcTemplate jdbcTemplate = DBUtils.createJdbcTemplate(jdbcUrl, username, password);
        System.out.println("\n--------------------------------------------------------testDatabase");
        DBUtils.testNativeConnection("org.h2.Driver", jdbcUrl, username, password);
        System.out.println("\n--------------------------------------------------------testJdbcTemplate");
        DBUtils.testJdbcTemplate(jdbcTemplate);
        System.out.println("\n--------------------------------------------------------testScript");
        EmbeddedH2DatabaseServer.testScript(jdbcTemplate);
        new CountDownLatch(1).await();
    }

    private static String buildJdbcUrl(String dbName) throws IOException {
        String dataDir = MavenProjects.getProjectBaseDir() + "/target/h2/";
        File file = new File(dataDir);
        if (file.exists()) {
            PathUtils.deleteDirectory((Path)file.toPath());
        }
        Files.mkdir((File)file);
        return "jdbc:h2:" + dataDir + dbName;
    }

    private static void testScript(JdbcTemplate jdbcTemplate) {
        String scriptPath = MavenProjects.getProjectBaseDir() + "/src/main/DB/H2/H2_SCRIPT.sql";
        jdbcTemplate.execute(conn -> {
            try {
                String script = IOUtils.toString((InputStream)new FileInputStream(scriptPath), (Charset)StandardCharsets.UTF_8);
                RunScript.execute((Connection)conn, (Reader)new StringReader(script));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        });
        List result = jdbcTemplate.queryForList("SELECT * FROM test1");
        String expect = MapUtils.getString((Map)((Map)result.get(0)), (Object)"NAME");
        String actual = MapUtils.getString((Map)((Map)result.get(0)), (Object)"NAME");
        Assert.isTrue((boolean)expect.equals(actual), () -> expect + " != " + actual);
        System.out.println("Query result: " + Jsons.toJson((Object)result));
    }
}

