/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.test.db;

import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.DBConfigurationBuilder;
import cn.ponfee.scheduler.common.base.exception.CheckedThrowing;
import cn.ponfee.scheduler.common.util.Files;
import cn.ponfee.scheduler.common.util.MavenProjects;
import cn.ponfee.scheduler.test.db.DBUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class EmbeddedMysqlServerMariaDB {
    public static void main(String[] args) throws Exception {
        DB db = EmbeddedMysqlServerMariaDB.start(3306);
        Runtime.getRuntime().addShutdownHook(new Thread(CheckedThrowing.runnable(() -> ((DB)db).stop())));
    }

    public static DB start(int port) throws Exception {
        DBConfiguration configuration = DBConfigurationBuilder.newBuilder().setPort(port).setBaseDir(EmbeddedMysqlServerMariaDB.createDirectory("base")).setDataDir(EmbeddedMysqlServerMariaDB.createDirectory("data")).build();
        DB db = DB.newEmbeddedDB((DBConfiguration)configuration);
        System.out.println("Embedded maria db starting...");
        db.start();
        System.out.println("Embedded maria db started!");
        db.source(IOUtils.toInputStream((String)EmbeddedMysqlServerMariaDB.loadScript(), (Charset)StandardCharsets.UTF_8));
        String jdbcUrl = "jdbc:mysql://localhost:" + port + "/" + "distributed_scheduler";
        JdbcTemplate jdbcTemplate = DBUtils.createJdbcTemplate(jdbcUrl, "distributed_scheduler", "distributed_scheduler");
        System.out.println("\n--------------------------------------------------------testDatabase");
        DBUtils.testNativeConnection("com.mysql.cj.jdbc.Driver", jdbcUrl, "distributed_scheduler", "distributed_scheduler");
        System.out.println("\n--------------------------------------------------------testMysql");
        DBUtils.testMysqlVersion(jdbcTemplate);
        System.out.println("\n--------------------------------------------------------testJdbcTemplate");
        DBUtils.testJdbcTemplate(jdbcTemplate);
        System.out.println("\n--------------------------------------------------------testQuerySql");
        DBUtils.testQuerySchedJob(jdbcTemplate);
        return db;
    }

    private static String loadScript() throws Exception {
        return Arrays.stream(DBUtils.loadScript().split("\n")).filter(s -> !StringUtils.startsWithAny((CharSequence)s, (CharSequence[])new CharSequence[]{"CREATE USER ", "GRANT ALL PRIVILEGES ON ", "FLUSH PRIVILEGES;"})).collect(Collectors.joining("\n"));
    }

    private static String createDirectory(String name) throws IOException {
        String dataDir = MavenProjects.getProjectBaseDir() + "/target/mariadb/" + name + "/";
        File file = new File(dataDir);
        if (file.exists()) {
            PathUtils.deleteDirectory((Path)file.toPath());
        }
        Files.mkdir((File)file);
        return dataDir;
    }
}

