/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.test.db;

import cn.ponfee.scheduler.test.db.DBUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public class EmbeddedMysqlServerTestcontainers {
    private static final List<String> PORT_BINDINGS = Collections.singletonList("3306:3306");

    public static void main(String[] args) throws Exception {
        DockerImageName dockerImage = DockerImageName.parse((String)"mysql/mysql-server:8.0.31").asCompatibleSubstituteFor("mysql");
        try (MySQLContainer mySQLContainer = (MySQLContainer)((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(dockerImage).withPrivilegedMode(true)).withUsername("root").withPassword("").withDatabaseName("test").withEnv("MYSQL_ROOT_HOST", "%")).withInitScript("JOB_TABLES_DDL.sql")).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(EmbeddedMysqlServerTestcontainers.class)));){
            mySQLContainer.setPortBindings(PORT_BINDINGS);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((MySQLContainer)mySQLContainer).close()));
            System.out.println("Embedded docker mysql starting...");
            mySQLContainer.start();
            System.out.println("Embedded docker mysql started!");
            JdbcTemplate jdbcTemplate = DBUtils.createJdbcTemplate("jdbc:mysql://localhost:3306/distributed_scheduler", "distributed_scheduler", "distributed_scheduler");
            System.out.println("\n--------------------------------------------------------testMysql");
            DBUtils.testMysqlVersion(jdbcTemplate);
            System.out.println("\n--------------------------------------------------------testJdbcTemplate");
            DBUtils.testJdbcTemplate(jdbcTemplate);
            System.out.println("\n--------------------------------------------------------testQuerySql");
            DBUtils.testQuerySchedJob(jdbcTemplate);
            new CountDownLatch(1).await();
        }
    }
}

