/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.test;

import ch.vorburger.mariadb4j.DB;
import cn.ponfee.scheduler.common.base.exception.CheckedThrowing;
import cn.ponfee.scheduler.test.db.EmbeddedMysqlServerMariaDB;
import cn.ponfee.scheduler.test.redis.EmbeddedRedisServerKstyrc;
import redis.embedded.RedisServer;

public final class EmbeddedMysqlAndRedisServer {
    private DB mariaDBServer;
    private RedisServer redisServer;

    public static void main(String[] args) {
        EmbeddedMysqlAndRedisServer.starter().start();
    }

    private EmbeddedMysqlAndRedisServer(int mysqlPort, int redisMasterPort, int redisSlavePort) {
        System.out.println("/*============================================================*\\");
        this.mariaDBServer = (DB)CheckedThrowing.caught(() -> EmbeddedMysqlServerMariaDB.start(mysqlPort));
        System.out.println("\\*============================================================*/");
        System.out.println("\n\n\n\n\n\n");
        System.out.println("/*============================================================*\\");
        this.redisServer = EmbeddedRedisServerKstyrc.start(redisMasterPort, redisSlavePort);
        System.out.println("\\*============================================================*/");
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public synchronized void stop() {
        if (this.mariaDBServer != null) {
            CheckedThrowing.caught(() -> ((DB)this.mariaDBServer).stop());
            this.mariaDBServer = null;
        }
        if (this.redisServer != null) {
            CheckedThrowing.caught(() -> this.redisServer.stop());
            this.redisServer = null;
        }
    }

    public static Starter starter() {
        return new Starter();
    }

    public static class Starter {
        private int mysqlPort = 3306;
        private int redisMasterPort = 6379;
        private int redisSlavePort = 6380;

        private Starter() {
        }

        public Starter mysqlPort(int mysqlPort) {
            this.mysqlPort = mysqlPort;
            return this;
        }

        public Starter redisMasterPort(int redisMasterPort) {
            this.redisMasterPort = redisMasterPort;
            return this;
        }

        public Starter redisSlavePort(int redisSlavePort) {
            this.redisSlavePort = redisSlavePort;
            return this;
        }

        public EmbeddedMysqlAndRedisServer start() {
            return new EmbeddedMysqlAndRedisServer(this.mysqlPort, this.redisMasterPort, this.redisSlavePort);
        }
    }
}

