/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.test.db;

import cn.ponfee.scheduler.common.util.Files;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.common.util.MavenProjects;
import cn.ponfee.scheduler.test.db.DBTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.h2.server.web.DbStarter;
import org.h2.tools.RunScript;
import org.junit.Assert;
import org.springframework.jdbc.core.JdbcTemplate;

public class EmbeddedH2DatabaseServer {
    public static void main(String[] args) throws Exception {
        String jdbcUrl = EmbeddedH2DatabaseServer.buildJdbcUrl("test");
        String username = "sa";
        String password = "";
        System.out.println("Embedded h2 database starting...");
        new DbStarter();
        System.out.println("Embedded h2 database started!");
        JdbcTemplate jdbcTemplate = DBTools.createJdbcTemplate(jdbcUrl, username, password);
        System.out.println("\n--------------------------------------------------------testDatabase");
        DBTools.testNativeConnection("org.h2.Driver", jdbcUrl, username, password);
        System.out.println("\n--------------------------------------------------------testJdbcTemplate");
        DBTools.testJdbcTemplate(jdbcTemplate);
        System.out.println("\n--------------------------------------------------------testScript");
        EmbeddedH2DatabaseServer.testScript(jdbcTemplate);
        new CountDownLatch(1).await();
    }

    private static String buildJdbcUrl(String dbName) throws IOException {
        String dataDir = MavenProjects.getProjectBaseDir() + "/target/h2/";
        File file = new File(dataDir);
        if (file.exists()) {
            PathUtils.deleteDirectory((Path)file.toPath());
        }
        Files.mkdir((File)file);
        return "jdbc:h2:" + dataDir + dbName;
    }

    private static void testScript(JdbcTemplate jdbcTemplate) {
        String scriptPath = MavenProjects.getProjectBaseDir() + "/src/test/DB/H2/H2_SCRIPT.sql";
        jdbcTemplate.execute(conn -> {
            try {
                String script = IOUtils.toString((InputStream)new FileInputStream(scriptPath), (Charset)StandardCharsets.UTF_8);
                RunScript.execute((Connection)conn, (Reader)new StringReader(script));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        });
        List result = jdbcTemplate.queryForList("SELECT * FROM test1");
        Assert.assertEquals((Object)"ae452457b1df438fa441e5640b162da6", ((Map)result.get(0)).get("NAME"));
        System.out.println("Query result: " + Jsons.toJson((Object)result));
    }
}

