/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.test.redis;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.junit.Assert;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public final class EmbeddedRedisServerTestcontainers {
    private static final String NACOS_DOCKER_IMAGE_NAME = "redis:6.2.8";
    private static final List<String> PORT_BINDINGS = Collections.singletonList("6379:6379");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        DockerImageName consulImage = DockerImageName.parse((String)NACOS_DOCKER_IMAGE_NAME).asCompatibleSubstituteFor("redis-test");
        GenericContainer dockerRedisContainer = new GenericContainer(consulImage).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(EmbeddedRedisServerTestcontainers.class))).withPrivilegedMode(true);
        dockerRedisContainer.setPortBindings(PORT_BINDINGS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((GenericContainer)dockerRedisContainer).close()));
        try {
            System.out.println("Embedded docker redis server starting...");
            dockerRedisContainer.start();
            System.out.println("Embedded docker redis server started!");
            dockerRedisContainer.execInContainer(new String[]{"redis-cli", "config set requirepass 123456"});
            Assert.assertEquals(PORT_BINDINGS, (Object)dockerRedisContainer.getPortBindings());
            new CountDownLatch(1).await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            dockerRedisContainer.close();
        }
    }
}

