/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker;

import cn.ponfee.scheduler.common.base.Startable;
import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.exception.Throwables;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteTaskParam;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.worker.base.RotatingTimingWheel;
import cn.ponfee.scheduler.worker.base.WorkerThreadPool;
import cn.ponfee.scheduler.worker.configuration.WorkerProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.Assert;

public class WorkerStartup
implements Startable {
    private final WorkerThreadPool workerThreadPool;
    private final Worker currentWorker;
    private final WorkerRegistry workerRegistry;
    private final TaskReceiver taskReceiver;
    private final RotatingTimingWheel rotatingTimingWheel;
    private final AtomicBoolean started = new AtomicBoolean(false);

    private WorkerStartup(Worker currentWorker, WorkerProperties workerConfig, SupervisorService supervisorServiceClient, WorkerRegistry workerRegistry, TaskReceiver taskReceiver) {
        Assert.notNull((Object)currentWorker, (String)"Current worker cannot null.");
        workerConfig.check();
        Assert.notNull((Object)supervisorServiceClient, (String)"Supervisor service client cannot null.");
        Assert.notNull((Object)workerRegistry, (String)"Server registry cannot null.");
        Assert.notNull((Object)taskReceiver, (String)"Task receiver cannot null.");
        this.currentWorker = currentWorker;
        this.workerThreadPool = new WorkerThreadPool(workerConfig.getMaximumPoolSize(), workerConfig.getKeepAliveTimeSeconds(), supervisorServiceClient);
        this.workerRegistry = workerRegistry;
        this.taskReceiver = taskReceiver;
        this.rotatingTimingWheel = new RotatingTimingWheel(currentWorker, supervisorServiceClient, (Discovery<Supervisor>)workerRegistry, (TimingWheel<ExecuteTaskParam>)taskReceiver.getTimingWheel(), this.workerThreadPool, workerConfig.getUpdateTaskWorkerThreadPoolSize());
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.workerThreadPool.start();
        this.rotatingTimingWheel.start();
        this.taskReceiver.start();
        this.workerRegistry.register((Server)this.currentWorker);
    }

    public void stop() {
        Throwables.caught(() -> ((WorkerRegistry)this.workerRegistry).close());
        Throwables.caught(() -> ((TaskReceiver)this.taskReceiver).close());
        Throwables.caught(() -> ((RotatingTimingWheel)this.rotatingTimingWheel).close());
        Throwables.caught(this.workerThreadPool::close);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Worker currentWorker;
        private WorkerProperties workerConfig;
        private SupervisorService supervisorServiceClient;
        private WorkerRegistry workerRegistry;
        private TaskReceiver taskReceiver;

        private Builder() {
        }

        public Builder currentWorker(Worker currentWorker) {
            this.currentWorker = currentWorker;
            return this;
        }

        public Builder workerConfig(WorkerProperties workerConfig) {
            this.workerConfig = workerConfig;
            return this;
        }

        public Builder supervisorServiceClient(SupervisorService supervisorServiceClient) {
            this.supervisorServiceClient = supervisorServiceClient;
            return this;
        }

        public Builder workerRegistry(WorkerRegistry workerRegistry) {
            this.workerRegistry = workerRegistry;
            return this;
        }

        public Builder taskReceiver(TaskReceiver taskReceiver) {
            this.taskReceiver = taskReceiver;
            return this;
        }

        public WorkerStartup build() {
            return new WorkerStartup(this.currentWorker, this.workerConfig, this.supervisorServiceClient, this.workerRegistry, this.taskReceiver);
        }
    }
}

