/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker.configuration;

import cn.ponfee.scheduler.common.spring.SpringContextHolder;
import cn.ponfee.scheduler.common.util.ClassUtils;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import cn.ponfee.scheduler.core.base.HttpProperties;
import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.base.WorkerService;
import cn.ponfee.scheduler.core.util.JobUtils;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.DiscoveryRestProxy;
import cn.ponfee.scheduler.registry.DiscoveryRestTemplate;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.worker.base.TaskTimingWheel;
import cn.ponfee.scheduler.worker.configuration.WorkerProperties;
import cn.ponfee.scheduler.worker.configuration.WorkerStartupRunner;
import cn.ponfee.scheduler.worker.rpc.WorkerServiceProvider;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@EnableConfigurationProperties(value={WorkerProperties.class})
@Import(value={EnableHttpProperties.class, EnableWorkerConfiguration.class, WorkerStartupRunner.class})
public @interface EnableWorker {

    @ConditionalOnProperty(value={"server.port"})
    public static class EnableWorkerConfiguration {
        @AutoConfigureOrder(value=-2147483648)
        @Order(value=-2147483648)
        @ConditionalOnMissingBean
        @Bean(value={"distributed.scheduler.bean.timing-wheel"})
        public TaskTimingWheel timingWheel(WorkerProperties config) {
            return new TaskTimingWheel(config.getTimingWheelTickMs(), config.getTimingWheelRingSize());
        }

        @AutoConfigureOrder(value=-2147483648)
        @Order(value=-2147483648)
        @DependsOn(value={"distributed.scheduler.bean.timing-wheel"})
        @ConditionalOnMissingBean
        @Bean(value={"distributed.scheduler.bean.current-worker"})
        public Worker currentWorker(@Value(value="${server.port}") int port, @Value(value="${distributed.scheduler.bound.server.host:}") String boundHost, WorkerProperties config) {
            String host = JobUtils.getLocalHost((String)boundHost);
            Worker currentWorker = new Worker(config.getGroup(), ObjectUtils.uuid32(), host, port);
            try {
                ClassUtils.invoke(Class.forName(Worker.class.getName() + "$Current"), (String)"set", (Object[])new Object[]{currentWorker});
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("Setting as current worker occur error.", e);
            }
            return currentWorker;
        }

        @DependsOn(value={"distributed.scheduler.bean.current-worker"})
        @ConditionalOnMissingClass(value={"cn.ponfee.scheduler.supervisor.manager.SchedulerJobManager"})
        @ConditionalOnMissingBean
        @Bean
        public SupervisorService supervisorServiceClient(HttpProperties httpConfig, WorkerRegistry workerRegistry, @Nullable @Qualifier(value="distributed.scheduler.bean.object-mapper") ObjectMapper objectMapper) {
            DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().connectTimeout(httpConfig.getConnectTimeout()).readTimeout(httpConfig.getReadTimeout()).maxRetryTimes(httpConfig.getMaxRetryTimes()).objectMapper(objectMapper != null ? objectMapper : Jsons.createObjectMapper((JsonInclude.Include)JsonInclude.Include.NON_NULL)).discoveryServer((Discovery)workerRegistry).build();
            return (SupervisorService)DiscoveryRestProxy.create((boolean)false, SupervisorService.class, (DiscoveryRestTemplate)discoveryRestTemplate);
        }

        @DependsOn(value={"distributed.scheduler.bean.current-worker"})
        @ConditionalOnMissingBean
        @Bean
        public WorkerService workerService() {
            return new WorkerServiceProvider();
        }

        @ConditionalOnMissingBean
        @Bean
        public SpringContextHolder springContextHolder() {
            return new SpringContextHolder();
        }
    }

    @ConditionalOnMissingBean(value={HttpProperties.class})
    @EnableConfigurationProperties(value={HttpProperties.class})
    public static class EnableHttpProperties {
    }
}

