/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker.configuration;

import cn.ponfee.scheduler.common.base.ToJsonString;
import java.io.Serializable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="distributed.scheduler.worker")
public class WorkerProperties
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 7914242555106016172L;
    private String group = "default";
    private long timingWheelTickMs = 100L;
    private int timingWheelRingSize = 60;
    private int maximumPoolSize = 100;
    private int keepAliveTimeSeconds = 300;
    private int updateTaskWorkerThreadPoolSize = 5;

    public void check() {
        Assert.hasText((String)this.group, (String)"Group cannot be blank.");
        Assert.isTrue((this.timingWheelTickMs > 0L ? 1 : 0) != 0, (String)"Timing wheel tick ms must be greater than 0.");
        Assert.isTrue((this.timingWheelRingSize > 0 ? 1 : 0) != 0, (String)"Timing wheel ring size must be greater than 0.");
        Assert.isTrue((this.maximumPoolSize > 0 ? 1 : 0) != 0, (String)"Maximum pool size must be greater 0.");
        Assert.isTrue((this.keepAliveTimeSeconds > 0 ? 1 : 0) != 0, (String)"Keep alive time seconds must be greater 0.");
        Assert.isTrue((this.updateTaskWorkerThreadPoolSize > 0 ? 1 : 0) != 0, (String)"Update task worker thread pool size must be greater than 0.");
    }

    public String getGroup() {
        return this.group;
    }

    public long getTimingWheelTickMs() {
        return this.timingWheelTickMs;
    }

    public int getTimingWheelRingSize() {
        return this.timingWheelRingSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getKeepAliveTimeSeconds() {
        return this.keepAliveTimeSeconds;
    }

    public int getUpdateTaskWorkerThreadPoolSize() {
        return this.updateTaskWorkerThreadPoolSize;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setTimingWheelTickMs(long timingWheelTickMs) {
        this.timingWheelTickMs = timingWheelTickMs;
    }

    public void setTimingWheelRingSize(int timingWheelRingSize) {
        this.timingWheelRingSize = timingWheelRingSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTimeSeconds(int keepAliveTimeSeconds) {
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    public void setUpdateTaskWorkerThreadPoolSize(int updateTaskWorkerThreadPoolSize) {
        this.updateTaskWorkerThreadPoolSize = updateTaskWorkerThreadPoolSize;
    }
}

