/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.worker.WorkerHeartbeatThread;
import cn.ponfee.scheduler.worker.base.WorkerThreadPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.Assert;

public class WorkerStartup
implements AutoCloseable {
    private final WorkerThreadPool workerThreadPool;
    private final Worker currentWorker;
    private final WorkerRegistry workerRegistry;
    private final TaskReceiver taskReceiver;
    private final WorkerHeartbeatThread workerHeartbeatThread;
    private final AtomicBoolean start = new AtomicBoolean(false);

    private WorkerStartup(Worker currentWorker, int maximumPoolSize, int keepAliveTimeSeconds, SupervisorService supervisorClient, WorkerRegistry workerRegistry, TaskReceiver taskReceiver) {
        Assert.notNull((Object)currentWorker, (String)"Current worker cannot null.");
        Assert.isTrue((maximumPoolSize > 0 ? 1 : 0) != 0, (String)"Maximum pool size must be greater zero.");
        Assert.isTrue((keepAliveTimeSeconds > 0 ? 1 : 0) != 0, (String)"Keep alive time seconds must be greater zero.");
        Assert.notNull((Object)supervisorClient, (String)"Supervisor client cannot null.");
        Assert.notNull((Object)workerRegistry, (String)"Server registry cannot null.");
        Assert.notNull((Object)taskReceiver, (String)"Task receiver cannot null.");
        this.currentWorker = currentWorker;
        this.workerThreadPool = new WorkerThreadPool(maximumPoolSize, keepAliveTimeSeconds, supervisorClient);
        this.workerRegistry = workerRegistry;
        this.taskReceiver = taskReceiver;
        this.workerHeartbeatThread = new WorkerHeartbeatThread((Discovery<Supervisor>)workerRegistry, (TimingWheel<ExecuteParam>)taskReceiver.getTimingWheel(), this.workerThreadPool);
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        this.workerThreadPool.start();
        this.workerHeartbeatThread.start();
        this.taskReceiver.start();
        this.workerRegistry.register((Server)this.currentWorker);
    }

    @Override
    public void close() {
        Throwables.caught(() -> ((WorkerRegistry)this.workerRegistry).close());
        Throwables.caught(() -> ((TaskReceiver)this.taskReceiver).close());
        Throwables.caught(() -> this.workerHeartbeatThread.doStop(1000L));
        Throwables.caught(this.workerThreadPool::close);
    }

    public static WorkerStartupBuilder builder() {
        return new WorkerStartupBuilder();
    }

    public static class WorkerStartupBuilder {
        private Worker currentWorker;
        private int maximumPoolSize;
        private int keepAliveTimeSeconds;
        private SupervisorService supervisorClient;
        private WorkerRegistry workerRegistry;
        private TaskReceiver taskReceiver;

        public WorkerStartupBuilder currentWorker(Worker currentWorker) {
            this.currentWorker = currentWorker;
            return this;
        }

        public WorkerStartupBuilder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public WorkerStartupBuilder keepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        public WorkerStartupBuilder supervisorClient(SupervisorService supervisorClient) {
            this.supervisorClient = supervisorClient;
            return this;
        }

        public WorkerStartupBuilder workerRegistry(WorkerRegistry workerRegistry) {
            this.workerRegistry = workerRegistry;
            return this;
        }

        public WorkerStartupBuilder taskReceiver(TaskReceiver taskReceiver) {
            this.taskReceiver = taskReceiver;
            return this;
        }

        public WorkerStartup build() {
            return new WorkerStartup(this.currentWorker, this.maximumPoolSize, this.keepAliveTimeSeconds, this.supervisorClient, this.workerRegistry, this.taskReceiver);
        }
    }
}

