/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.core.base.AbstractHeartbeatThread;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.worker.base.WorkerThreadPool;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class WorkerHeartbeatThread
extends AbstractHeartbeatThread {
    private final Discovery<Supervisor> discoverySupervisor;
    private final TimingWheel<ExecuteParam> timingWheel;
    private final WorkerThreadPool workerThreadPool;
    private int round = 0;

    public WorkerHeartbeatThread(Discovery<Supervisor> discoverySupervisor, TimingWheel<ExecuteParam> timingWheel, WorkerThreadPool threadPool) {
        super(1);
        this.discoverySupervisor = discoverySupervisor;
        this.timingWheel = timingWheel;
        this.workerThreadPool = threadPool;
    }

    protected boolean heartbeat() {
        if (++this.round == 120) {
            this.round = 0;
            this.log.info("worker-thread-pool: {}, jvm-active-count: {}", (Object)this.workerThreadPool, (Object)Thread.activeCount());
        }
        return this.process();
    }

    private boolean process() {
        if (CollectionUtils.isEmpty((Collection)this.discoverySupervisor.getDiscoveredServers())) {
            this.log.warn("Not available supervisors.");
            return false;
        }
        List ringTrigger = this.timingWheel.poll();
        if (ringTrigger.isEmpty()) {
            return false;
        }
        for (ExecuteParam param : ringTrigger) {
            this.workerThreadPool.submit(param);
        }
        ringTrigger.clear();
        return true;
    }
}

