/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker.configuration;

import cn.ponfee.scheduler.common.util.ClassUtils;
import cn.ponfee.scheduler.common.util.Networks;
import cn.ponfee.scheduler.common.util.ObjectUtils;
import cn.ponfee.scheduler.core.base.Worker;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={CurrentWorkerConfiguration.class})
public @interface EnableWorker {

    @ConditionalOnClass(value={Worker.class})
    @ConditionalOnProperty(value={"server.port"})
    @AutoConfigureOrder(value=-2147483648)
    public static class CurrentWorkerConfiguration {
        @Bean(value={"currentSupervisor"})
        @Order(value=-2147483648)
        @ConditionalOnMissingBean
        public Worker currentWorker(@Value(value="${server.port}") int port, @Value(value="${distributed.scheduler.worker.group:default}") String group) {
            Worker currentWorker = new Worker(group, ObjectUtils.uuid32(), Networks.getHostIp(), port);
            try {
                ClassUtils.invoke(Class.forName(Worker.class.getName() + "$Current"), (String)"set", (Object[])new Object[]{currentWorker});
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError("Setting as current worker occur error.", e);
            }
            return currentWorker;
        }
    }
}

