/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker;

import cn.ponfee.scheduler.common.base.TimingWheel;
import cn.ponfee.scheduler.common.base.exception.Throwables;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.core.param.ExecuteParam;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.registry.Discovery;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.worker.base.WorkerThreadPool;
import cn.ponfee.scheduler.worker.thread.RotatingTimingWheelThread;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.Assert;

public class WorkerStartup
implements AutoCloseable {
    private final WorkerThreadPool workerThreadPool;
    private final Worker currentWorker;
    private final WorkerRegistry workerRegistry;
    private final TaskReceiver taskReceiver;
    private final RotatingTimingWheelThread rotatingTimingWheelThread;
    private final AtomicBoolean started = new AtomicBoolean(false);

    private WorkerStartup(Worker currentWorker, int maximumPoolSize, int keepAliveTimeSeconds, SupervisorService SupervisorServiceClient, WorkerRegistry workerRegistry, TaskReceiver taskReceiver) {
        Assert.notNull((Object)currentWorker, (String)"Current worker cannot null.");
        Assert.isTrue((maximumPoolSize > 0 ? 1 : 0) != 0, (String)"Maximum pool size must be greater zero.");
        Assert.isTrue((keepAliveTimeSeconds > 0 ? 1 : 0) != 0, (String)"Keep alive time seconds must be greater zero.");
        Assert.notNull((Object)SupervisorServiceClient, (String)"Supervisor service client cannot null.");
        Assert.notNull((Object)workerRegistry, (String)"Server registry cannot null.");
        Assert.notNull((Object)taskReceiver, (String)"Task receiver cannot null.");
        this.currentWorker = currentWorker;
        this.workerThreadPool = new WorkerThreadPool(maximumPoolSize, keepAliveTimeSeconds, SupervisorServiceClient);
        this.workerRegistry = workerRegistry;
        this.taskReceiver = taskReceiver;
        this.rotatingTimingWheelThread = new RotatingTimingWheelThread(currentWorker, SupervisorServiceClient, (Discovery<Supervisor>)workerRegistry, (TimingWheel<ExecuteParam>)taskReceiver.getTimingWheel(), this.workerThreadPool);
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.workerThreadPool.start();
        this.rotatingTimingWheelThread.start();
        this.taskReceiver.start();
        this.workerRegistry.register((Server)this.currentWorker);
    }

    @Override
    public void close() {
        Throwables.caught(() -> ((WorkerRegistry)this.workerRegistry).close());
        Throwables.caught(() -> ((TaskReceiver)this.taskReceiver).close());
        Throwables.caught(() -> this.rotatingTimingWheelThread.doStop(1000L));
        Throwables.caught(this.workerThreadPool::close);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Worker currentWorker;
        private int maximumPoolSize;
        private int keepAliveTimeSeconds;
        private SupervisorService SupervisorServiceClient;
        private WorkerRegistry workerRegistry;
        private TaskReceiver taskReceiver;

        private Builder() {
        }

        public Builder currentWorker(Worker currentWorker) {
            this.currentWorker = currentWorker;
            return this;
        }

        public Builder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public Builder keepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        public Builder SupervisorServiceClient(SupervisorService SupervisorServiceClient) {
            this.SupervisorServiceClient = SupervisorServiceClient;
            return this;
        }

        public Builder workerRegistry(WorkerRegistry workerRegistry) {
            this.workerRegistry = workerRegistry;
            return this;
        }

        public Builder taskReceiver(TaskReceiver taskReceiver) {
            this.taskReceiver = taskReceiver;
            return this;
        }

        public WorkerStartup build() {
            return new WorkerStartup(this.currentWorker, this.maximumPoolSize, this.keepAliveTimeSeconds, this.SupervisorServiceClient, this.workerRegistry, this.taskReceiver);
        }
    }
}

