/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.worker.configuration;

import cn.ponfee.scheduler.core.base.SupervisorService;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.dispatch.TaskReceiver;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.worker.WorkerStartup;
import cn.ponfee.scheduler.worker.configuration.WorkerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;

@AutoConfigureOrder(value=0x7FFFFFFF)
public class WorkerStartupRunner
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerStartupRunner.class);
    private final WorkerStartup workerStartup;

    public WorkerStartupRunner(Worker currentWorker, WorkerProperties properties, SupervisorService SupervisorServiceClient, WorkerRegistry workerRegistry, TaskReceiver taskReceiver) {
        this.workerStartup = WorkerStartup.builder().currentWorker(currentWorker).maximumPoolSize(properties.getMaximumPoolSize()).keepAliveTimeSeconds(properties.getKeepAliveTimeSeconds()).SupervisorServiceClient(SupervisorServiceClient).workerRegistry(workerRegistry).taskReceiver(taskReceiver).build();
    }

    public void run(ApplicationArguments args) {
        LOG.info("Scheduler worker launch begin...");
        this.workerStartup.start();
        LOG.info("Scheduler worker launch end.");
    }

    public void destroy() {
        LOG.info("Scheduler worker stop begin...");
        this.workerStartup.close();
        LOG.info("Scheduler worker stop end.");
    }
}

