package cn.rl520.druid.config;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wwb
 * @version 1.0
 **/
@Configuration
public class RlDynamicDataSourceConfig {

    @ConfigurationProperties(prefix = "spring.datasource.base")
    @Bean(name = "baseDataSource")
    @Primary
    public DruidDataSource baseDataSource() {
        DruidDataSource druidDataSource = new DruidDataSource();
        List<Filter> filterList = new ArrayList<Filter>();
        filterList.add(wallFilter(wallConfig()));
        druidDataSource.setProxyFilters(filterList);
        return druidDataSource;
    }

    @ConfigurationProperties(prefix = "spring.datasource.master")
    @Bean(name = "masterDataSource")
    @Primary
    public DruidDataSource masterDataSource() {
        DruidDataSource masterDataSource = new DruidDataSource();
        List<Filter> filterList = new ArrayList<Filter>();
        filterList.add(wallFilter(wallConfig()));
        masterDataSource.setProxyFilters(filterList);
        return masterDataSource;
    }

    @ConfigurationProperties(prefix = "spring.datasource.read")
    @Bean(name = "readDataSource")
    public DruidDataSource readDataSource() {
        DruidDataSource readDataSource = new DruidDataSource();
        List<Filter> filterList = new ArrayList<Filter>();
        filterList.add(wallFilter(wallConfig()));
        readDataSource.setProxyFilters(filterList);
        return readDataSource;
    }


    @Bean(name = "dataSource")
    public RlDynamicDataSource dataSource(@Qualifier("baseDataSource")DataSource baseDataSource){
        // 可调度数据源的父级数据源
        RlDynamicDataSource rlDynamicDataSource = new RlDynamicDataSource();
        // 存储可选择的数据源集合
        Map<Object,Object> targetDataSources = new HashMap<Object,Object>();
        targetDataSources.put("baseDataSource",baseDataSource);
        targetDataSources.put("readDataSource",readDataSource());
        targetDataSources.put("masterDataSource",masterDataSource());
        rlDynamicDataSource.setTargetDataSources(targetDataSources);
        // 存储默认数据源
        rlDynamicDataSource.setDefaultTargetDataSource(baseDataSource);
        rlDynamicDataSource.afterPropertiesSet();
        return rlDynamicDataSource;
    }


    @Bean(name = "wallFilter")
    public WallFilter wallFilter(@Qualifier("wallConfig") WallConfig wallConfig) {
        WallFilter wallFilter = new WallFilter();
        wallFilter.setConfig(wallConfig);
        return wallFilter;
    }

    @Bean(name = "wallConfig")
    public WallConfig wallConfig() {
        WallConfig config = new WallConfig();
        // 是否允许一次执行多条SQL脚本，如遇特殊情况，比如局部临时表数据存储后读取需要在此处设置为true
        config.setMultiStatementAllow(true);
        // 如遇druid无法支持的语法，如：UNPIVOT、WITH TEMP等，此处设置为false，不做严格语法检查
        config.setStrictSyntaxCheck(false);
        return config;
    }


    //因为Springboot内置了servlet容器，所以没有web.xml，替代方法就是将ServletRegistrationBean注册进去
    //加入后台监控
    @Bean  //这里其实就相当于servlet的web.xml
    public ServletRegistrationBean statViewServlet(){
        ServletRegistrationBean<StatViewServlet> bean =
                new ServletRegistrationBean<StatViewServlet>(new StatViewServlet(),"/monitor/druid/*");
        //后台需要有人登录，进行配置
        //bean.addUrlMappings(); 这个可以添加映射，我们在构造里已经写了
        //设置一些初始化参数
        Map<String,String> initParas = new HashMap<String,String>();
//        initParas.put("loginUsername","admin");//它这个账户密码是固定的
//        initParas.put("loginPassword","123456");
        //允许谁能访问
        initParas.put("allow","");//这个值为空或没有就允许所有人访问，ip白名单
        //initParas.put("allow","localhost");//只允许本机访问，多个ip用逗号,隔开
        //initParas.put("deny","");//ip黑名单，拒绝谁访问 deny和allow同时存在优先deny
        initParas.put("resetEnable","false");//禁用HTML页面的Reset按钮
        bean.setInitParameters(initParas);
        return bean;
    }

    //再配置一个过滤器，Servlet按上面的方式注册Filter也只能这样
    @Bean
    public FilterRegistrationBean webStatFilter(){
        FilterRegistrationBean bean = new FilterRegistrationBean();
        //可以设置也可以获取,设置一个阿里巴巴的过滤器
        bean.setFilter(new WebStatFilter());
        bean.addUrlPatterns("/*");
        //可以过滤和排除哪些东西
        Map<String,String> initParams = new HashMap<String,String>();
        //把不需要监控的过滤掉,这些不进行统计
        initParams.put("exclusions","*.js,*.css,/monitor/druid/*");
        bean.setInitParameters(initParams);
        return bean;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(@Qualifier("dataSource") RlDynamicDataSource dataSource) throws Exception {
        final SqlSessionFactoryBean sqlSessionFactory = new SqlSessionFactoryBean();
        sqlSessionFactory.setDataSource(dataSource);
        sqlSessionFactory.setConfigLocation(new ClassPathResource("mybatis-config.xml"));
        sqlSessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapping/*.xml"));
        sqlSessionFactory.setFailFast(true);
        return sqlSessionFactory.getObject();
    }
}
