package cn.rl520.druid.utils;

import cn.rl520.druid.dto.DbConnProperties;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wwb
 * @version 1.0
 **/
public class RlDataBaseRegisteredUtil {

    public static void register(String registerName,ConfigurableApplicationContext applicationContext, DbConnProperties dbConnProperties) {
        // 构建Bean名称
        String wallConfigBeanName = registerName + "WallConfig";
        String wallFilterBeanName = registerName + "WallFilter";
        String dataSourceBeanName = registerName + "DataSource";
        // 检查DataSource Bean是否存在,如果存在则直接推出
        if(applicationContext.containsBean(dataSourceBeanName)) {
            Object bean = applicationContext.getBean(dataSourceBeanName);
            if (bean.getClass().isAssignableFrom(DruidDataSource.class)) {
                return;
            } else {
                throw new RuntimeException("Bean 名称重复,且该Bean不是DataSource Bean!");
            }
        }
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry) applicationContext.getBeanFactory();
        // 构造参数Bean wallConfig
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(WallConfig.class);
        BeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(wallConfigBeanName, beanDefinition);
        WallConfig wallConfig = (WallConfig) applicationContext.getBean(wallConfigBeanName);
        // 是否允许一次执行多条SQL脚本，如遇特殊情况，比如局部临时表数据存储后读取需要在此处设置为true
        wallConfig.setMultiStatementAllow(true);
        // 如遇druid无法支持的语法，如：UNPIVOT、WITH TEMP等，此处设置为false，不做严格语法检查
        wallConfig.setStrictSyntaxCheck(false);

        // 构造参数Bean wallFilter
        beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(WallFilter.class);
        beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(wallFilterBeanName, beanDefinition);
        WallFilter wallFilter = (WallFilter) applicationContext.getBean(wallFilterBeanName);
        wallFilter.setConfig(wallConfig);

        // 构造DataSource Bean
        beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DruidDataSource.class);
        beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(dataSourceBeanName, beanDefinition);
        DruidDataSource druidDataSource = (DruidDataSource) applicationContext.getBean(dataSourceBeanName);
        // 设置连接信息，这里默认所有数据库在同一服务器上，直接替换库名即可
        druidDataSource.setDriverClassName(dbConnProperties.getDriverClassName());druidDataSource.setUrl(dbConnProperties.getUrl());
        druidDataSource.setUsername(dbConnProperties.getUserName());
        druidDataSource.setPassword(dbConnProperties.getPassword());
        // 设置过滤信息
        List<Filter> filterList = new ArrayList<Filter>();
        filterList.add(wallFilter);
        druidDataSource.setProxyFilters(filterList);
    }

}
