package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ams")
public class AMSController {
    @Value("${spring.profiles.active}")
    private String activeProfile;

    @Resource
    private AMSListener amsListener;

    @Resource
    private AMSListListener amsListListener;

    @Resource
    private List<AMSOperation> amsOperationList;

    private JSONArray blocks = new JSONArray();

    private List<String> scriptPathList = new ArrayList<String>();

    @PostConstruct
    public void postConstruct() throws IOException {
        amsListListener.initialBlocks(blocks);
        scriptPathList.add("router.js");
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/operation"));
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/page"));
    }

    @RequestMapping("/config")
    public JSONObject config() throws IOException {
        if(!"docker".equals(activeProfile)){
            blocks.clear();
            scriptPathList.clear();

            postConstruct();
        }
        JSONObject config = new JSONObject();
        config.put("applicationName", amsListener.applicationName());
        config.put("blocks", blocks);
        config.put("scriptPathList", scriptPathList);
        return config;
    }

    @RequestMapping("/api/{daoName}/{tableName}/list")
    public JSONObject list(
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ){
        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition = dao.query(entity.clazz);
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        amsListListener.beforeExecuteCondition(daoName, tableName, condition, amsListCondition);
        PageVo pageVo = condition.execute().getPagingList();
        amsListListener.afterExecuteCondition(daoName, tableName, pageVo);
        return AMSUtil.getAMSPagingList(pageVo);
    }

    @RequestMapping("/api/{daoName}/{tableName}/{methodName}")
    public void dispatcherRequest(
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @PathVariable("methodName") String methodName,
            @RequestBody(required = false) JSONObject requestBody
    ) throws Exception {
        for(AMSOperation amsOperation:amsOperationList){
            if(!daoName.equalsIgnoreCase(amsOperation.daoName())){
                continue;
            }
            if(!tableName.equalsIgnoreCase(amsOperation.tableName())){
                continue;
            }
            if(StringUtils.isNoneBlank(amsOperation.methodName())&&!methodName.equalsIgnoreCase(amsOperation.methodName())){
                continue;
            }
            amsOperation.handle(methodName, requestBody);
            return;
        }
        throw new IllegalArgumentException("不支持的操作!dao:"+daoName+",表名:"+tableName+",方法名:"+methodName);
    }
}
