ams.utils.getIdList = function (params, idField) {
    if (typeof idField == "undefined") {
        idField = "id";
    }
    let ids = [];
    let array = params.$prevReturn;
    if (Array.isArray(array)) {
        for (let i = 0; i < array.length; i++) {
            ids.push(array[i][idField]);
        }
    } else {
        let id = array[idField];
        if (null != id && "" !== id) {
            ids.push(id);
        }
    }
    return ids;
};

ams.utils.getIdsString = function (params, idField) {
    let idList = ams.utils.getIdList(params, idField);
    return idList.join(",");
};

ams.utils.getDataList = function (params) {
    let returnArray = [];
    let array = params.$prevReturn;
    if (Array.isArray(array)) {
        for (let i = 0; i < array.length; i++) {
            returnArray.push(array[i]);
        }
    } else {
        returnArray.push(array);
    }
    return returnArray;
};

ams.utils.sendRequest = function (activeBlock, option, message) {
    let prefix = activeBlock.resource.api.prefix;
    option.url = prefix + option.url;
    activeBlock.showLoading();
    return ams.request(option).then((response) => {
        if (response.data.code !== 0) {
            activeBlock.$message.error(response.data.msg);
            return;
        }
        activeBlock.$message.success(message);
        activeBlock.callAction("list:1");
    }).finally(() => {
        activeBlock.hideLoading();
    });
};