/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.advice;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSListener;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class AMSExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(AMSExceptionHandler.class);
    @Resource
    private AMSListener amsListener;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public AMSResult handleException(Exception ex) {
        this.amsListener.beforePrintError(ex);
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u5904\u7406", (Throwable)ex);
        if (ex instanceof NullPointerException) {
            return new AMSResult("\u540e\u53f0\u7a7a\u6307\u9488\u5f02\u5e38!" + ex.getMessage());
        }
        return new AMSResult(ex.getMessage());
    }
}

