/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.ams.service.DefaultAMSDispatcherService;
import cn.schoolwow.ams.util.AMSUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams"})
public class AMSController {
    @Value(value="${spring.profiles.active}")
    private String activeProfile;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired
    private AMSListener amsListener;
    @Autowired
    private AMSListListener amsListListener;
    @Autowired(required=false)
    private AMSDispatcherService amsDispatcherService;
    private DefaultAMSDispatcherService defaultAMSDispatcherService;
    private JSONArray blocks = new JSONArray();
    private List<String> scriptPathList = new ArrayList<String>();

    @PostConstruct
    public void postConstruct() throws IOException {
        JSONObject block;
        int i;
        this.amsListListener.initialBlocks(this.blocks);
        for (i = 0; i < this.blocks.size(); ++i) {
            block = this.blocks.getJSONObject(i);
            if (block.containsKey((Object)"projectName")) continue;
            block.put("projectName", (Object)this.amsListener.projectName());
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            block = this.blocks.getJSONObject(i);
            Validate.notEmpty((CharSequence)block.getString("projectName"), (String)"block\u9879\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)block.getString("daoName"), (String)"block\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)block.getString("tableName"), (String)"block\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String uniqueKey = block.getString("projectName") + "|" + block.getString("daoName") + "|" + block.getString("tableName");
            block.put("uniqueKey", (Object)uniqueKey);
            block.put("resourceName", (Object)(uniqueKey + "|resource"));
            block.put("listBlockName", (Object)(uniqueKey + "|listBlock"));
        }
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/commonOperation"));
        this.scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/ams"));
        this.amsListListener.initialScriptPath(this.scriptPathList);
        this.defaultAMSDispatcherService = new DefaultAMSDispatcherService(this.applicationContext);
    }

    @RequestMapping(value={"/config"})
    public JSONObject config() throws IOException {
        if (!"docker".equals(this.activeProfile)) {
            this.blocks.clear();
            this.scriptPathList.clear();
            this.postConstruct();
        }
        JSONObject config = new JSONObject();
        config.put("projectName", (Object)this.amsListener.projectName());
        config.put("applicationName", (Object)this.amsListener.applicationName());
        config.put("blocks", (Object)this.blocks);
        config.put("scriptPathList", this.scriptPathList);
        return config;
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/list"})
    public JSONObject list(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        if (null != this.amsDispatcherService) {
            return this.amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
        }
        if (null != this.defaultAMSDispatcherService) {
            return this.defaultAMSDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/create"})
    public void create(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject createEntity) throws Exception {
        if (null != this.amsDispatcherService) {
            this.amsDispatcherService.create(projectName, daoName, tableName, createEntity);
        } else if (null != this.defaultAMSDispatcherService) {
            this.defaultAMSDispatcherService.create(projectName, daoName, tableName, createEntity);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
        }
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/edit"})
    public void edit(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject updateEntity) throws Exception {
        if (null != this.amsDispatcherService) {
            this.amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
        } else if (null != this.defaultAMSDispatcherService) {
            this.defaultAMSDispatcherService.edit(projectName, daoName, tableName, updateEntity);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
        }
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/delete"})
    public void delete(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        if (null != this.amsDispatcherService) {
            this.amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
        } else if (null != this.defaultAMSDispatcherService) {
            this.defaultAMSDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
        }
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/{methodName}"})
    public JSONObject operationDispatcher(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @PathVariable(value="methodName") String methodName, @RequestBody(required=false) JSONObject requestBody) throws Exception {
        if (null != this.amsDispatcherService) {
            return this.amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
        }
        if (null != this.defaultAMSDispatcherService) {
            return this.defaultAMSDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
    }

    @RequestMapping(value={"/api/{projectName}/remoteSelect/{type}"})
    public JSONArray remoteSelect(@PathVariable(value="projectName") String projectName, @PathVariable(value="type") String type, @RequestParam(required=false) Map<String, String> amsRemoteSelectMap) throws Exception {
        if (null != this.amsDispatcherService) {
            return this.amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
        }
        if (null != this.defaultAMSDispatcherService) {
            return this.defaultAMSDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
    }
}

