function getMatchBlock(block){
    //匹配公共部分
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];

        if(projectName===block["projectName"]&&daoName==="common"&&tableName===block["tableName"]){
            return userBlockMap[prop];
        }
    }
    //完全匹配
    for(let prop in userBlockMap){
        let tokens = prop.split("|");
        let projectName = tokens[0];
        let daoName = tokens[1];
        let tableName = tokens[2];

        if(projectName===block["projectName"]&&daoName===block["daoName"]&&tableName===block["tableName"]){
            return userBlockMap[prop];
        }
    }
}

function loadBlock(block){
    let matchBlock = getMatchBlock(block);
    loadResource(block, matchBlock);
    loadListBlock(block, matchBlock);
}

function loadResource(block, matchBlock) {
    let resourceBlock = {
        "key": block["id"],
        "api": {
            "prefix": "/ams/api/"+block["projectName"]+"/"+block["daoName"]+"/"+block["tableName"],
            "list": "/list",
            "create": "/create",
            "update": "/update",
            "delete": "/delete"
        },
        "fields": block["resourceFields"]
    };
    if(null!=matchBlock&&matchBlock.hasOwnProperty("resource")){
        mergeBlock(matchBlock["resource"], resourceBlock);
        delete matchBlock["resource"];
    }
    ams.resource(block["resourceName"], resourceBlock);
}

function loadListBlock(block, matchBlock){
    let listBlock = {
        "resource": block["resourceName"],
        "type": "list",
        "ctx": "view",
        "props": {
            "empty-text": "暂无记录",
        },
        "sorts": {},
        "expand": {},
        "options": {
            "multipleSelect": true,
        },
        "operations":{

        },
        "actions": {
            copyRow(params) {
                let row = params.$prevReturn;
                setClipBoard(JSON.stringify(row));
                this.$message.success("行数据已复制到剪贴板");
            },
            multipleDelete(params){
                let idFieldName = block["id"];
                let ids = ams.utils.getIdsString(params, idFieldName);
                let data = {};
                data[idFieldName] = "in:"+ids;

                return ams.utils.sendRequest(this, {
                    "method": "POST",
                    "url": "/delete",
                    "data": data,
                    "contentType": "form"
                }, "删除记录完成!");
            }
        }
    };
    if(block["initList"]){
        listBlock["events"] = {
            "init": "@list"
        };
    }
    listBlock["operations"] = block["operationFields"];

    for(let prop in block["resourceFields"]){
        listBlock["sorts"][prop] = true;
        listBlock["expand"][prop] = true;
        if(prop==="id"){
            listBlock["data"] = {
                "searchs": {
                    "sortField": "id",
                    "sortOrder": "desc"
                }
            };
        }
    }
    mergeBlock(matchBlock, listBlock);

    listBlock["operations"] = Object.assign(listBlock["operations"], {
        "tableHeader": {
            "slot": "rightTop",
            "type": "filter",
            "label": "表头管理",
            "props": {
                "type": "primary",
            },
        },
        "search": {
            "slot": "searchs",
            "type": "button",
            "label": "搜索",
            "props": {
                "type": "primary",
                "icon": "el-icon-search"
            },
            "event": "list:1"
        },
        "copyRow": {
            "type": "button",
            "label": "复制行",
            "props": {
                "type": "primary",
                "icon": "el-icon-copy"
            },
            "event": "copyRow"
        },
    });
    ams.block(block["listBlockName"], listBlock);

    if(listBlock.hasOwnProperty("headerNames")){
        //设置默认表头展示列
        let itemName = "AMS_BLOCK_"+block["listBlockName"];
        if(null==localStorage.getItem(itemName)){
            localStorage.setItem(itemName,"\""+listBlock["headerNames"]+"\"");
        }
    }
}

function mergeBlock(sourceBlock,targetBlock){
    for(let prop in sourceBlock){
        if(typeof(sourceBlock[prop])=="object"){
            targetBlock[prop] = Object.assign(targetBlock[prop], sourceBlock[prop]);
        }else{
            targetBlock[prop] = sourceBlock[prop];
        }
    }
}