package cn.schoolwow.ams.service;

import cn.schoolwow.ams.domain.BeforeEditOption;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.listener.AMSRemoteSelect;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dml.DatabaseManipulation;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.UpdateType;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DefaultAMSDispatcherService implements AMSDispatcherService{
    private AMSListListener amsListListener;

    private Collection<AMSTableListener> amsTableListenerList;

    private Collection<AMSOperation> amsOperationList;

    private Collection<AMSRemoteSelect> amsRemoteSelectList;

    public DefaultAMSDispatcherService(ApplicationContext applicationContext) {
        this.amsListListener = applicationContext.getBeansOfType(AMSListListener.class).values().iterator().next();
        this.amsTableListenerList = applicationContext.getBeansOfType(AMSTableListener.class).values();
        this.amsOperationList = applicationContext.getBeansOfType(AMSOperation.class).values();
        this.amsRemoteSelectList = applicationContext.getBeansOfType(AMSRemoteSelect.class).values();
    }

    @Override
    public JSONObject list(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition;
        if(null==entity){
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for(Property property:entity.properties){
                condition.addColumn(property.column + " " + StringUtil.underline2Camel(property.column));
            }
        }else{
            condition = dao.query(entity.clazz);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        Optional<AMSTableListener> optional = Optional.ofNullable(getAMSTableListener(daoName, tableName));
        optional.ifPresent(amsTableListener -> {
            amsTableListener.beforeExecuteCondition(condition, amsListCondition);
        });
        PageVo pageVo = condition.execute().getPagingList();
        optional.ifPresent(amsTableListener -> {
            amsTableListener.afterExecuteCondition(condition, amsListCondition, pageVo);
        });
        return AMSUtil.getAMSPagingList(pageVo);
    }

    @Override
    public void create(String projectName, String daoName, String tableName, JSONObject createEntity) {
        Optional<AMSTableListener> optional = Optional.ofNullable(getAMSTableListener(daoName, tableName));
        optional.ifPresent(amsTableListener -> {
            amsTableListener.beforeCreate(createEntity);
        });
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if(null==entity){
            Set<String> keySet = createEntity.keySet();
            for(String key:keySet){
                Object value = createEntity.get(key);
                createEntity.put(StringUtil.camel2Underline(key), value);
                createEntity.remove(key);
            }
            dao.insert(tableName, createEntity);
        }else{
            Object instance = createEntity.toJavaObject(entity.clazz);
            dao.insert(instance);
        }
        optional.ifPresent(amsTableListener -> {
            amsTableListener.afterCreate(createEntity);
        });
    }

    @Override
    public void edit(String projectName, String daoName, String tableName, JSONObject updateEntity) {
        BeforeEditOption beforeEditOption = null;
        AMSTableListener amsTableListener = getAMSTableListener(daoName, tableName);
        if(null!=amsTableListener){
            beforeEditOption = amsTableListener.beforeEdit(updateEntity);
        }
        if(null==beforeEditOption){
            beforeEditOption = new BeforeEditOption();
        }

        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if(null==entity){
            Validate.isTrue(null!=beforeEditOption.uniqueFieldNameArray&&beforeEditOption.uniqueFieldNameArray.length>0, "jsonObject格式更新,必须制定唯一字段名称列表!");
            Set<String> keySet = updateEntity.keySet();
            for(String key:keySet){
                Object value = updateEntity.get(key);
                updateEntity.put(StringUtil.camel2Underline(key), value);
                updateEntity.remove(key);
            }
            DatabaseManipulation dml = dao.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            if(null!=beforeEditOption.partColumnArray&&beforeEditOption.partColumnArray.length>0){
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            dml.updateType(beforeEditOption.updateType).update(tableName, updateEntity);
        }else{
            DatabaseManipulation dml = dao.updateType(UpdateType.UpdateByUniqueKey);
            if(null!=beforeEditOption.partColumnArray&&beforeEditOption.partColumnArray.length>0){
                dml.partColumn(beforeEditOption.partColumnArray);
            }
            if(null!=beforeEditOption.uniqueFieldNameArray&&beforeEditOption.uniqueFieldNameArray.length>0){
                dml.uniqueFieldNames(beforeEditOption.uniqueFieldNameArray);
            }
            Object updateInstance = updateEntity.toJavaObject(entity.clazz);
            dml.updateType(beforeEditOption.updateType).update(updateInstance);
        }
        if(null!=amsTableListener){
            amsTableListener.afterEdit(beforeEditOption, updateEntity);
        }
    }

    @Override
    public void delete(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition = null;
        if(null==entity){
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
        }else{
            condition = dao.query(entity.clazz);
        }
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);

        AMSTableListener amsTableListener = getAMSTableListener(daoName, tableName);
        if(null!=amsTableListener){
            amsTableListener.beforeDelete(condition, amsListCondition);
        }
        condition.clone().execute().delete();
        if(null!=amsTableListener){
            amsTableListener.afterDelete(condition, amsListCondition);
        }
    }

    @Override
    public JSONObject operationDispatcher(String projectName, String daoName, String tableName, String methodName, JSONObject requestBody) throws Exception {
        if(null==amsOperationList){
            throw new IllegalArgumentException("不支持的操作!dao:"+daoName+",表名:"+tableName+",方法名:"+methodName);
        }
        for(AMSOperation amsOperation:amsOperationList){
            if(!daoName.equalsIgnoreCase(amsOperation.daoName())){
                continue;
            }
            if(!tableName.equalsIgnoreCase(amsOperation.tableName())){
                continue;
            }
            if(StringUtils.isNoneBlank(amsOperation.methodName())&&!methodName.equalsIgnoreCase(amsOperation.methodName())){
                continue;
            }
            return amsOperation.handle(methodName, requestBody);
        }
        throw new IllegalArgumentException("不支持的操作!项目名:"+projectName+",数据库名:"+daoName+",表名:"+tableName+",方法名:"+methodName);
    }

    @Override
    public JSONArray remoteSelect(String projectName, String type, Map<String, String> amsListConditionMap) throws Exception {
        for(AMSRemoteSelect amsRemoteSelect:amsRemoteSelectList){
            if(type.equalsIgnoreCase(amsRemoteSelect.type())){
                return amsRemoteSelect.getRemoteOption(amsListConditionMap);
            }
        }
        throw new IllegalArgumentException("未匹配到下拉框选项!项目名:"+projectName+",类型:"+type);
    }

    private AMSTableListener getAMSTableListener(String daoName, String tableName){
        if(null==amsTableListenerList){
            return null;
        }
        for(AMSTableListener amsTableListener:amsTableListenerList){
            if(amsTableListener.daoName().equals(daoName)
                    &&amsTableListener.tableName().equals(tableName)){
                return amsTableListener;
            }
        }
        return null;
    }
}
