ams.utils.getIdList = function (params, idField) {
    if (typeof idField == "undefined") {
        idField = "id";
    }
    let ids = [];
    let array = params.$prevReturn;
    if (Array.isArray(array)) {
        for (let i = 0; i < array.length; i++) {
            ids.push(array[i][idField]);
        }
    } else {
        let id = array[idField];
        if (null != id && "" !== id) {
            ids.push(id);
        }
    }
    return ids;
};

ams.utils.getIdsString = function (params, idField) {
    let idList = ams.utils.getIdList(params, idField);
    return idList.join(",");
};

ams.utils.getDataList = function (params) {
    let returnArray = [];
    let array = params.$prevReturn;
    if (Array.isArray(array)) {
        for (let i = 0; i < array.length; i++) {
            returnArray.push(array[i]);
        }
    } else {
        returnArray.push(array);
    }
    return returnArray;
};

ams.utils.sendRequest = function (activeBlock, option, message) {
    let prefix = activeBlock.resource.api.prefix;
    option.url = prefix + option.url;
    activeBlock.showLoading();
    return ams.request(option).then((response) => {
        if (response.data.code !== 0) {
            activeBlock.$message.error(response.data.msg);
            return;
        }
        activeBlock.$message.success(message);
        activeBlock.callAction("list:1");
    }).finally(() => {
        activeBlock.hideLoading();
    });
};

ams.utils.getResourceFields = function(block, fieldNames){
    let fields = block.resource.fields;
    let returnFields = {};
    for(let i=0;i<fieldNames.length;i++){
        let fieldName = fieldNames[i];
        returnFields[fieldName] = fields[fieldName];
    }
    return returnFields;
};

ams.utils.disabledResourceFields = function(fields, disabledFieldNames){
    for(let i=0;i<disabledFieldNames.length;i++){
        let field = fields[disabledFieldNames[i]];
        if(!field.hasOwnProperty("props")){
            field["props"] = {
                "disabled":true
            }
        }else{
            field["props"]["disabled"] = true;
        }
    }
};

ams.utils.addItemDialog = function(block, createApi, fields){
    let prefix = block.resource.api.prefix;
    return block.callAction("@addItemDialog", {
        "resource": {
            "api": {
                "prefix": prefix,
                "create": createApi
            },
            "fields": fields
        }
    });
};

ams.utils.editItemDialog = function(block, updateApi, fields){
    let prefix = block.resource.api.prefix;
    return block.callAction("@editItemDialog", {
        "resource": {
            "api": {
                "prefix": prefix,
                "update": updateApi
            },
            "fields": fields
        }
    });
};