/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.block;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BlockBuilder {
    private JSONObject block = new JSONObject();

    public BlockBuilder() {
        this.block.put("id", (Object)"id");
        this.block.put("initList", (Object)true);
    }

    public static BlockBuilder newInstance() {
        return new BlockBuilder();
    }

    public BlockBuilder databaseBlock(String daoName, Entity entity) {
        Property updateAtProperty;
        List propertyList = entity.properties;
        ArrayList<Property> propertyList1 = new ArrayList<Property>(propertyList);
        propertyList1.removeIf(property -> property.column.equalsIgnoreCase("created_at") || property.column.equalsIgnoreCase("updated_at"));
        Property createAtProperty = entity.getPropertyByFieldNameOrColumnName("created_at");
        if (null != createAtProperty) {
            propertyList1.add(createAtProperty);
        }
        if (null != (updateAtProperty = entity.getPropertyByFieldNameOrColumnName("updated_at"))) {
            propertyList1.add(updateAtProperty);
        }
        entity.properties.clear();
        entity.properties.addAll(propertyList1);
        this.addDatabaseEntityBlock(daoName, entity);
        return this;
    }

    public BlockBuilder projectName(String projectName) {
        this.block.put("projectName", (Object)projectName);
        return this;
    }

    public BlockBuilder classBlock(Class clazz) {
        return this.classBlock(clazz.getSimpleName(), clazz, clazz);
    }

    public BlockBuilder classBlock(String tableName, Class requestClass, Class responseClass) {
        this.addClassBlock(tableName, requestClass, responseClass);
        return this;
    }

    public BlockBuilder idField(String idField) {
        this.block.put("id", (Object)idField);
        return this;
    }

    public BlockBuilder initList(boolean initList) {
        this.block.put("initList", (Object)initList);
        return this;
    }

    public JSONObject getBlock() {
        return this.block;
    }

    private void addDatabaseEntityBlock(String daoName, Entity entity) {
        this.block.put("daoName", (Object)daoName);
        this.block.put("tableName", (Object)entity.tableName);
        List propertyList = entity.properties;
        JSONObject resourceFields = new JSONObject(true);
        JSONObject operationFields = new JSONObject(true);
        for (Property property : propertyList) {
            switch (property.column) {
                case "created_at": {
                    property.comment = "\u521b\u5efa\u65f6\u95f4";
                    break;
                }
                case "updated_at": {
                    property.comment = "\u66f4\u65b0\u65f6\u95f4";
                }
            }
            if (!property.column.equalsIgnoreCase("id") && property.comment.isEmpty()) continue;
            JSONObject field = new JSONObject();
            if (property.column.equalsIgnoreCase("id")) {
                property.comment = "id";
            }
            if (property.comment.contains("(")) {
                String[] tokens;
                String comment = property.comment.substring(0, property.comment.indexOf("("));
                field.put("label", (Object)comment);
                field.put("info", (Object)("\u8bf7\u9009\u62e9" + comment));
                field.put("type", (Object)"select");
                JSONObject props = new JSONObject();
                field.put("props", (Object)props);
                props.put("placeholder", (Object)("\u8bf7\u9009\u62e9" + comment));
                props.put("clearable", (Object)true);
                props.put("multiple", (Object)false);
                JSONObject options = new JSONObject();
                props.put("options", (Object)options);
                String selectText = property.comment.substring(property.comment.indexOf("(") + 1, property.comment.indexOf(")"));
                for (String token : tokens = selectText.split(",")) {
                    int indexOf = token.indexOf(":");
                    if (indexOf < 0) {
                        throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u6ce8\u91ca\u5f02\u5e38!\u8868\u540d:" + entity.tableName + ",\u5b57\u6bb5\u540d:" + property.name + ",\u6ce8\u91ca:" + property.comment);
                    }
                    String key = token.substring(0, indexOf);
                    String value = token.substring(indexOf + 1);
                    options.put(key, (Object)(value + "(" + key + ")"));
                }
            } else {
                field.put("label", (Object)property.comment);
                field.put("info", (Object)property.comment);
                if (property.columnType.contains("date") || property.columnType.contains("timestamp")) {
                    field.put("type", (Object)"datetime");
                } else if (property.comment.startsWith("\u662f\u5426")) {
                    field.put("type", (Object)"switch");
                } else if (property.column.contains("url")) {
                    field.put("type", (Object)"link");
                } else {
                    field.put("type", (Object)"text");
                }
                JSONObject props = new JSONObject();
                field.put("props", (Object)props);
                props.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + property.comment));
            }
            String label = StringUtil.underline2Camel((String)property.column);
            resourceFields.put(label, (Object)field);
            JSONObject operation = new JSONObject();
            operation.put("slot", (Object)"searchs");
            operation.put("type", (Object)"field");
            operation.put("label", (Object)field.getString("label"));
            operation.put("field", (Object)field);
            operationFields.put(label, (Object)operation);
        }
        this.block.put("resourceFields", (Object)resourceFields);
        this.block.put("operationFields", (Object)operationFields);
    }

    private void addClassBlock(String tableName, Class requestClass, Class responseClass) {
        JSONObject field;
        AccessibleObject[] entityFields;
        this.block.put("daoName", (Object)"clazz");
        this.block.put("tableName", (Object)tableName);
        JSONObject fieldMap = new JSONObject(true);
        if (null != requestClass) {
            entityFields = requestClass.getDeclaredFields();
            Field.setAccessible(entityFields, true);
            for (AccessibleObject entityField : entityFields) {
                field = this.getAMSField(requestClass, (Field)entityField);
                JSONObject operation = new JSONObject();
                operation.put("slot", (Object)"searchs");
                operation.put("type", (Object)"field");
                operation.put("label", (Object)field.getString("label"));
                operation.put("field", (Object)field);
                operation.put("info", (Object)field.getString("info"));
                fieldMap.put(((Field)entityField).getName(), (Object)operation);
            }
        }
        this.block.put("operationFields", (Object)fieldMap);
        fieldMap = new JSONObject(true);
        entityFields = responseClass.getDeclaredFields();
        Field.setAccessible(entityFields, true);
        for (AccessibleObject entityField : entityFields) {
            field = this.getAMSField(responseClass, (Field)entityField);
            fieldMap.put(((Field)entityField).getName(), (Object)field);
        }
        this.block.put("resourceFields", (Object)fieldMap);
    }

    private JSONObject getAMSField(Class clazz, Field entityField) {
        String comment;
        JSONObject field = new JSONObject();
        Comment commentAnnotation = entityField.getAnnotation(Comment.class);
        String string = comment = null == commentAnnotation ? entityField.getName() : commentAnnotation.value();
        if (comment.contains("(")) {
            String[] tokens;
            String fieldComment = comment.substring(0, comment.indexOf("("));
            field.put("label", (Object)fieldComment);
            field.put("info", (Object)("\u8bf7\u9009\u62e9" + fieldComment));
            field.put("type", (Object)"select");
            JSONObject props = new JSONObject();
            field.put("props", (Object)props);
            props.put("placeholder", (Object)("\u8bf7\u9009\u62e9" + fieldComment));
            props.put("clearable", (Object)true);
            props.put("multiple", (Object)false);
            JSONObject options = new JSONObject();
            props.put("options", (Object)options);
            String selectText = comment.substring(comment.indexOf("(") + 1, comment.indexOf(")"));
            for (String token : tokens = selectText.split(",")) {
                int indexOf = token.indexOf(":");
                if (indexOf < 0) {
                    throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u6ce8\u91ca\u5f02\u5e38!\u7c7b\u540d:" + clazz.getName() + ",\u5b57\u6bb5\u540d:" + entityField.getName() + ",\u6ce8\u91ca:" + comment);
                }
                String key = token.substring(0, indexOf);
                String value = token.substring(indexOf + 1);
                options.put(key, (Object)(value + "(" + key + ")"));
            }
        } else {
            field.put("label", (Object)comment);
            field.put("info", (Object)("\u8bf7\u8f93\u5165" + comment));
            switch (entityField.getType().getName()) {
                case "java.util.Date": {
                    field.put("type", (Object)"date");
                    break;
                }
                case "java.sql.Timestamp": 
                case "java.sql.LocalDate": 
                case "java.sql.LocalDateTime": {
                    field.put("type", (Object)"datetime");
                    break;
                }
                default: {
                    field.put("type", (Object)"text");
                }
            }
            JSONObject props = new JSONObject();
            field.put("props", (Object)props);
            props.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + comment));
        }
        return field;
    }
}

