package cn.schoolwow.ams.block;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Field;
import java.util.List;

public class BlockBuilder {
    private JSONObject block = new JSONObject();
    {
        block.put("id", "id");
    }

    public static BlockBuilder newInstance(){
        return new BlockBuilder();
    }

    /**添加数据库区块*/
    public BlockBuilder databaseBlock(String daoName, Entity entity){
        addDatabaseEntityBlock(daoName, entity);
        return this;
    }

    /**添加实体类区块*/
    public BlockBuilder classBlock(Class clazz){
        return classBlock(clazz.getSimpleName(), clazz, clazz);
    }

    /**添加实体类区块*/
    public BlockBuilder classBlock(String tableName, Class requestClass, Class responseClass){
        addClassBlock(tableName, requestClass, responseClass);
        return this;
    }

    /**指定主键*/
    public BlockBuilder idField(String idField){
        block.put("id", idField);
        return this;
    }

    public JSONObject getBlock(){
        return block;
    }

    /**添加数据库表区块*/
    private void addDatabaseEntityBlock(String daoName, Entity entity){
        block.put("daoName", daoName);
        block.put("tableName", entity.tableName);
        //字段
        {
            List<Property> propertyList = entity.properties;
            JSONObject resourceFields = new JSONObject(true);
            JSONObject operationFields = new JSONObject(true);
            for (Property property : propertyList) {
                switch (property.column) {
                    case "created_at": {
                        property.comment = "创建时间";
                    }
                    break;
                    case "updated_at": {
                        property.comment = "更新时间";
                    }
                    break;
                }
                if (!property.column.equalsIgnoreCase("id") && property.comment.isEmpty()) {
                    continue;
                }
                JSONObject field = new JSONObject();
                if (property.column.equalsIgnoreCase("id")) {
                    property.comment = "id";
                }
                //判断是否下拉选择
                if (property.comment.contains("(")) {
                    String comment = property.comment.substring(0, property.comment.indexOf("("));
                    field.put("label", comment);
                    field.put("info", "请选择" + comment);
                    field.put("type", "select");

                    JSONObject props = new JSONObject();
                    field.put("props", props);
                    props.put("placeholder", "请选择" + comment);
                    props.put("clearable", true);
                    props.put("multiple", false);

                    JSONObject options = new JSONObject();
                    props.put("options", options);

                    String selectText = property.comment.substring(property.comment.indexOf("(") + 1, property.comment.indexOf(")"));
                    String[] tokens = selectText.split(",");
                    for (String token : tokens) {
                        int indexOf = token.indexOf(":");
                        if (indexOf < 0) {
                            throw new IllegalArgumentException("实体类注释异常!表名:" + entity.tableName + ",字段名:" + property.name + ",注释:" + property.comment);
                        }
                        String key = token.substring(0, indexOf);
                        String value = token.substring(indexOf + 1);
                        options.put(key, value + "(" + key + ")");
                    }
                } else {
                    field.put("label", property.comment);
                    field.put("info", "请输入" + property.comment);
                    if (property.columnType.contains("date") || property.columnType.contains("timestamp")) {
                        field.put("type", "datetime");
                    } else if(property.comment.startsWith("是否")){
                        field.put("type", "switch");
                    }else if(property.column.contains("url")){
                        field.put("type", "link");
                    }else{
                        field.put("type", "text");
                    }

                    JSONObject props = new JSONObject();
                    field.put("props", props);
                    props.put("placeholder", "请输入" + property.comment);
                }
                String label = StringUtil.underline2Camel(property.column);
                resourceFields.put(label, field);

                JSONObject operation = new JSONObject();
                operation.put("slot", "searchs");
                operation.put("type", "field");
                operation.put("label", field.getString("label"));
                operation.put("field", field);
                operationFields.put(label, operation);
            }
            block.put("resourceFields", resourceFields);
            block.put("operationFields", operationFields);
        }
    }

    /**根据pojo类添加区块*/
    private void addClassBlock(String tableName, Class requestClass, Class responseClass) {
        block.put("tableName", tableName);
        block.put("daoName", "clazz");
        //请求字段
        {
            JSONObject fieldMap = new JSONObject(true);
            if(null!=requestClass){
                Field[] entityFields = requestClass.getDeclaredFields();
                Field.setAccessible(entityFields, true);
                for (Field entityField : entityFields) {
                    JSONObject field = getAMSField(requestClass, entityField);
                    JSONObject operation = new JSONObject();
                    operation.put("slot", "searchs");
                    operation.put("type", "field");
                    operation.put("label", field.getString("label"));
                    operation.put("field", field);
                    fieldMap.put(entityField.getName(), operation);
                }
            }
            block.put("operationFields", fieldMap);
        }
        //响应字段
        {
            JSONObject fieldMap = new JSONObject(true);
            Field[] entityFields = responseClass.getDeclaredFields();
            Field.setAccessible(entityFields, true);
            for (Field entityField : entityFields) {
                JSONObject field = getAMSField(responseClass, entityField);
                fieldMap.put(entityField.getName(), field);
            }
            block.put("resourceFields", fieldMap);
        }
    }

    private JSONObject getAMSField(Class clazz, Field entityField){
        JSONObject field = new JSONObject();
        String comment = entityField.getAnnotation(Comment.class).value();
        //判断是否下拉选择
        if (comment.contains("(")) {
            String fieldComment = comment.substring(0, comment.indexOf("("));
            field.put("label", fieldComment);
            field.put("info", "请选择" + fieldComment);
            field.put("type", "select");

            JSONObject props = new JSONObject();
            field.put("props", props);
            props.put("placeholder", "请选择" + fieldComment);
            props.put("clearable", true);
            props.put("multiple", false);

            JSONObject options = new JSONObject();
            props.put("options", options);

            String selectText = comment.substring(comment.indexOf("(") + 1, comment.indexOf(")"));
            String[] tokens = selectText.split(",");
            for (String token : tokens) {
                int indexOf = token.indexOf(":");
                if (indexOf < 0) {
                    throw new IllegalArgumentException("实体类注释异常!类名:" + clazz.getName() + ",字段名:" + entityField.getName() + ",注释:" + comment);
                }
                String key = token.substring(0, indexOf);
                String value = token.substring(indexOf + 1);
                options.put(key, value + "(" + key + ")");
            }
        } else {
            field.put("label", comment);
            field.put("info", "请输入" + comment);

            switch (entityField.getType().getName()) {
                case "java.util.Date":
                case "java.sql.Timestamp":
                case "java.sql.LocalDate":
                case "java.sql.LocalDateTime": {
                    field.put("type", "datetime");
                }
                break;
                default: {
                    field.put("type", "text");
                }
            }
            JSONObject props = new JSONObject();
            field.put("props", props);
            props.put("placeholder", "请输入" + comment);
        }
        return field;
    }
}
