package cn.schoolwow.ams.advice;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;

@ControllerAdvice
public class AMSExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(AMSExceptionHandler.class);

    @Resource
    private AMSListener amsListener;

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public AMSResult handleException(Exception ex) {
        amsListener.beforePrintError(ex);
        logger.error("全局异常处理", ex);
        if (ex instanceof NullPointerException) {
            return new AMSResult("后台空指针异常!" + ex.getMessage());
        }
        return new AMSResult(ex.getMessage());
    }

}
