package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.QuickAMS;
import cn.schoolwow.ams.flow.controller.GetConfigFlow;
import cn.schoolwow.ams.flow.controller.SetAmsInfoFlow;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.ams.service.DefaultAMSDispatcherService;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ams")
public class AMSController {
    @Resource
    private ApplicationContext applicationContext;

    @Autowired(required = false)
    private AMSDispatcherService amsDispatcherService;

    private DefaultAMSDispatcherService defaultAMSDispatcherService;

    private JSONArray blocks = new JSONArray();

    private List<String> scriptPathList = new ArrayList<String>();

    @PostConstruct
    public void postConstruct() {
        QuickAMS.quickFlow.startFlow(applicationContext.getBean(SetAmsInfoFlow.class))
                .putTemporaryData("blocks", blocks)
                .putTemporaryData("scriptPathList", scriptPathList)
                .execute();
        defaultAMSDispatcherService = new DefaultAMSDispatcherService(applicationContext);
    }

    @RequestMapping("/config")
    public JSONObject config() {
        FlowContext flowContext = QuickAMS.quickFlow.startFlow(applicationContext.getBean(GetConfigFlow.class))
                .putTemporaryData("blocks", blocks)
                .putTemporaryData("scriptPathList", scriptPathList)
                .execute();
        JSONObject config = (JSONObject) flowContext.checkData("config");
        return config;
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/list")
    public JSONObject list(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        if(null!=amsDispatcherService){
            return amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
        }else if(null!=defaultAMSDispatcherService){
            return defaultAMSDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
        }else{
            throw new UnsupportedOperationException("当前不存在AmsDispatcherService实例");
        }
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/create")
    public void create(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject createEntity
    ) throws Exception {
        if(null!=amsDispatcherService){
            amsDispatcherService.create(projectName, daoName, tableName, createEntity);
        }else if(null!=defaultAMSDispatcherService){
            defaultAMSDispatcherService.create(projectName, daoName, tableName, createEntity);
        }else{
            throw new UnsupportedOperationException("当前不存在AmsDispatcherService实例");
        }
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/edit")
    public void edit(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject updateEntity
    ) throws Exception {
        if(null!=amsDispatcherService){
            amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
        }else if(null!=defaultAMSDispatcherService){
            defaultAMSDispatcherService.edit(projectName, daoName, tableName, updateEntity);
        }else{
            throw new UnsupportedOperationException("当前不存在AmsDispatcherService实例");
        }
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/delete")
    public void delete(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        if(null!=amsDispatcherService){
            amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
        }else if(null!=defaultAMSDispatcherService){
            defaultAMSDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
        }else{
            throw new UnsupportedOperationException("当前不存在AmsDispatcherService实例");
        }
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/{methodName}")
    public JSONObject operationDispatcher(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @PathVariable("methodName") String methodName,
            @RequestBody(required = false) JSONObject requestBody
    ) throws Exception {
        if(null!=amsDispatcherService){
            return amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
        }else if(null!=defaultAMSDispatcherService){
            return defaultAMSDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
        }else{
            throw new UnsupportedOperationException("当前不存在AmsDispatcherService实例");
        }
    }

    @RequestMapping("/api/{projectName}/remoteSelect/{type}")
    public JSONArray remoteSelect(
            @PathVariable("projectName") String projectName,
            @PathVariable("type") String type,
            @RequestParam(required = false) Map<String, String> amsRemoteSelectMap
    ) throws Exception {
        if(null!=amsDispatcherService){
            return amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
        }else if(null!=defaultAMSDispatcherService){
            return defaultAMSDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
        }else{
            throw new UnsupportedOperationException("当前不存在AmsDispatcherService实例");
        }
    }

}
