package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Service
public class SetAmsInfoFlow implements BusinessFlow {
    @Autowired
    private AMSListener amsListener;

    @Autowired
    private AMSListListener amsListListener;

    @Autowired(required = false)
    private List<AMSOperation> amsOperationList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setBlocks(flowContext);
        setScriptPath(flowContext);
    }

    @Override
    public String name() {
        return "ams信息初始化";
    }

    private void setBlocks(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        amsListListener.initialBlocks(blocks);
        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            if(!block.containsKey("projectName")){
                block.put("projectName", amsListener.projectName());
            }
        }
        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            Validate.notEmpty(block.getString("projectName"), "block项目名不能为空");
            Validate.notEmpty(block.getString("daoName"), "block数据库名不能为空");
            Validate.notEmpty(block.getString("tableName"), "block表名不能为空");

            String uniqueKey = block.getString("projectName")+"|"+block.getString("daoName")+"|"+block.getString("tableName");
            block.put("uniqueKey", uniqueKey);
            block.put("resourceName", uniqueKey+"|resource");
            block.put("listBlockName", uniqueKey+"|listBlock");
        }
        for(AMSOperation amsOperation:amsOperationList){
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                if(!amsListener.projectName().equals(block.getString("projectName"))){
                    continue;
                }
                if(!amsOperation.daoName().equals(block.getString("daoName"))){
                    continue;
                }
                if(!amsOperation.tableName().equals(block.getString("tableName"))){
                    continue;
                }
                if(!block.containsKey("operations")){
                    block.put("operations", new JSONArray());
                }
                JSONArray operations = block.getJSONArray("operations");
                JSONObject operation = new JSONObject();
                operation.put("key", amsOperation.methodName());
                operation.put("label", amsOperation.name());
                operation.put("fieldNameList", amsOperation.fieldNameList());
                if(amsOperation.methodName().startsWith("multiple")){
                    operation.put("slot", "multipleSelect");
                }
                if(amsOperation.methodName().endsWith("RightTop")){
                    operation.put("slot", "rightTop");
                }
                operations.add(operation);
            }
        }
    }

    private void setScriptPath(FlowContext flowContext) throws IOException {
        List<String> scriptPathList = (List<String>) flowContext.getData("scriptPathList", new ArrayList<>());

        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/ams"));
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/commonOperation"));
        amsListListener.initialScriptPath(scriptPathList);
    }
}
