package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.flow.dispatcher.common.getAMSTableListenerFlow;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.util.Optional;
import java.util.Set;

public class CreateFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        JSONObject createEntity = (JSONObject) flowContext.checkData("createEntity");
        AMSListListener amsListListener = (AMSListListener) flowContext.checkData("amsListListener");

        AMSTableListener selectedAmsTableListener = (AMSTableListener) flowContext.executeFlowList(new getAMSTableListenerFlow()).getData("amsTableListener");
        Optional<AMSTableListener> optional = Optional.ofNullable(selectedAmsTableListener);
        optional.ifPresent(amsTableListener -> {
            amsTableListener.beforeCreate(createEntity);
        });
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        if(null==entity){
            Set<String> keySet = createEntity.keySet();
            for(String key:keySet){
                Object value = createEntity.get(key);
                createEntity.put(StringUtil.camel2Underline(key), value);
                createEntity.remove(key);
            }
            dao.insert(tableName, createEntity);
        }else{
            Object instance = createEntity.toJavaObject(entity.clazz);
            dao.insert(instance);
        }
        optional.ifPresent(amsTableListener -> {
            amsTableListener.afterCreate(createEntity);
        });
    }

    @Override
    public String name() {
        return "create操作";
    }
}
