package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Collection;

@Service
public class OperationDispatcherFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        String methodName = (String) flowContext.checkData("methodName");
        JSONObject requestBody = (JSONObject) flowContext.getData("requestBody");
        Collection<AMSOperation> amsOperationList = (Collection<AMSOperation>) flowContext.getData("amsOperationList");

        if(null==amsOperationList){
            throw new IllegalArgumentException("不支持的操作!dao:"+daoName+",表名:"+tableName+",方法名:"+methodName);
        }
        for(AMSOperation amsOperation:amsOperationList){
            if(!daoName.equalsIgnoreCase(amsOperation.daoName())){
                continue;
            }
            if(!tableName.equalsIgnoreCase(amsOperation.tableName())){
                continue;
            }
            if(StringUtils.isNoneBlank(amsOperation.methodName())&&!methodName.equalsIgnoreCase(amsOperation.methodName())){
                continue;
            }
            JSONObject response = amsOperation.handle(methodName, requestBody);
            flowContext.putData("response", response);
            return;
        }
        throw new IllegalArgumentException("不支持的操作!项目名:"+projectName+",数据库名:"+daoName+",表名:"+tableName+",方法名:"+methodName);
    }

    @Override
    public String name() {
        return "ams操作分发";
    }
}
