package cn.schoolwow.ams.service;

import cn.schoolwow.ams.QuickAMS;
import cn.schoolwow.ams.flow.dispatcher.*;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.listener.AMSRemoteSelect;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.ApplicationContext;

import java.util.Collection;
import java.util.Map;

public class DefaultAMSDispatcherService implements AMSDispatcherService{
    private AMSListListener amsListListener;

    private Collection<AMSTableListener> amsTableListenerList;

    private Collection<AMSOperation> amsOperationList;

    private Collection<AMSRemoteSelect> amsRemoteSelectList;

    public DefaultAMSDispatcherService(ApplicationContext applicationContext) {
        this.amsListListener = applicationContext.getBeansOfType(AMSListListener.class).values().iterator().next();
        this.amsTableListenerList = applicationContext.getBeansOfType(AMSTableListener.class).values();
        this.amsOperationList = applicationContext.getBeansOfType(AMSOperation.class).values();
        this.amsRemoteSelectList = applicationContext.getBeansOfType(AMSRemoteSelect.class).values();
    }

    @Override
    public JSONObject list(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        FlowContext flowContext = QuickAMS.quickFlow.startFlow(new ListFlow())
                .putTemporaryData("amsListListener", amsListListener)
                .putTemporaryData("amsTableListenerList", amsTableListenerList)
                .putTemporaryData("projectName", projectName)
                .putTemporaryData("daoName", daoName)
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("amsListConditionMap", amsListConditionMap)
                .execute();
        JSONObject list = (JSONObject) flowContext.checkData("list");
        return list;
    }

    @Override
    public void create(String projectName, String daoName, String tableName, JSONObject createEntity) {
        QuickAMS.quickFlow.startFlow(new CreateFlow())
                .putTemporaryData("amsListListener", amsListListener)
                .putTemporaryData("amsTableListenerList", amsTableListenerList)
                .putTemporaryData("projectName", projectName)
                .putTemporaryData("daoName", daoName)
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("createEntity", createEntity)
                .execute();
    }

    @Override
    public void edit(String projectName, String daoName, String tableName, JSONObject updateEntity) {
        QuickAMS.quickFlow.startFlow(new EditFlow())
                .putTemporaryData("amsListListener", amsListListener)
                .putTemporaryData("amsTableListenerList", amsTableListenerList)
                .putTemporaryData("projectName", projectName)
                .putTemporaryData("daoName", daoName)
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("updateEntity", updateEntity)
                .execute();
    }

    @Override
    public void delete(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        QuickAMS.quickFlow.startFlow(new DeleteFlow())
                .putTemporaryData("amsListListener", amsListListener)
                .putTemporaryData("amsTableListenerList", amsTableListenerList)
                .putTemporaryData("projectName", projectName)
                .putTemporaryData("daoName", daoName)
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("amsListConditionMap", amsListConditionMap)
                .execute();
    }

    @Override
    public JSONObject operationDispatcher(String projectName, String daoName, String tableName, String methodName, JSONObject requestBody) throws Exception {
        FlowContext flowContext = QuickAMS.quickFlow.startFlow(new OperationDispatcherFlow())
                .putTemporaryData("amsOperationList", amsOperationList)
                .putTemporaryData("projectName", projectName)
                .putTemporaryData("daoName", daoName)
                .putTemporaryData("tableName", tableName)
                .putTemporaryData("methodName", methodName)
                .putTemporaryData("requestBody", requestBody)
                .execute();
        JSONObject response = (JSONObject) flowContext.getData("response");
        return response;
    }

    @Override
    public JSONArray remoteSelect(String projectName, String type, Map<String, String> amsListConditionMap) throws Exception {
        for(AMSRemoteSelect amsRemoteSelect:amsRemoteSelectList){
            if(type.equalsIgnoreCase(amsRemoteSelect.type())){
                return amsRemoteSelect.getRemoteOption(amsListConditionMap);
            }
        }
        throw new IllegalArgumentException("未匹配到下拉框选项!项目名:"+projectName+",类型:"+type);
    }

}
