/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetAMSOperationFlow
implements BusinessFlow {
    @Autowired
    private AMSListener amsListener;
    @Autowired(required=false)
    private List<AMSOperation> amsOperationList;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if (null == this.amsOperationList || this.amsOperationList.isEmpty()) {
            return;
        }
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        for (AMSOperation amsOperation : this.amsOperationList) {
            for (int i = 0; i < blocks.size(); ++i) {
                String methodName;
                JSONObject block = blocks.getJSONObject(i);
                if (!this.amsListener.projectName().equals(block.getString("projectName")) || !amsOperation.daoName().equals(block.getString("daoName")) || !amsOperation.tableName().equals(block.getString("tableName")) || StringUtils.isBlank((CharSequence)(methodName = amsOperation.methodName())) || methodName.endsWith("Ignore")) continue;
                String name = amsOperation.name();
                Validate.notEmpty((CharSequence)name, (String)("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!\u7c7b\u540d:" + amsOperation.getClass().getName()), (Object[])new Object[0]);
                if (!block.containsKey((Object)"operationFields")) {
                    block.put("operationFields", (Object)new JSONObject(true));
                }
                JSONObject operationFields = block.getJSONObject("operationFields");
                JSONObject operationField = new JSONObject();
                this.setOperationField(operationField, amsOperation, true);
                operationFields.put(amsOperation.methodName(), (Object)operationField);
                if (!amsOperation.methodName().startsWith("multiple")) continue;
                JSONObject singleOperationField = new JSONObject();
                this.setOperationField(singleOperationField, amsOperation, false);
                operationFields.put("row_" + amsOperation.methodName(), (Object)singleOperationField);
            }
        }
    }

    public String name() {
        return "\u8bbe\u7f6e\u64cd\u4f5c\u6309\u94ae";
    }

    private void setOperationField(JSONObject operationField, AMSOperation amsOperation, boolean checkMultiple) {
        operationField.put("type", (Object)"button");
        operationField.put("label", (Object)amsOperation.name());
        JSONObject props = new JSONObject();
        props.put("type", (Object)"primary");
        amsOperation.props(props);
        operationField.put("props", (Object)props);
        String fieldNames = StringUtils.join((Object[])amsOperation.fieldNameList(), (String)",");
        operationField.put("event", (Object)("confirm:\u786e\u8ba4" + amsOperation.name() + "\u5417? sendRequest:" + amsOperation.methodName() + (StringUtils.isNotBlank((CharSequence)fieldNames) ? "," + fieldNames : "") + " list:1"));
        operationField.put("slot", (Object)"");
        if (amsOperation.methodName().endsWith("RightTop")) {
            operationField.put("slot", (Object)"rightTop");
        }
        if (checkMultiple && amsOperation.methodName().startsWith("multiple")) {
            operationField.put("slot", (Object)"multipleSelect");
            operationField.put("label", (Object)("\u6279\u91cf" + amsOperation.name()));
            operationField.put("event", (Object)("confirm:\u786e\u8ba4\u6279\u91cf" + amsOperation.name() + "\u5417? sendRequest:" + amsOperation.methodName() + (StringUtils.isNotBlank((CharSequence)fieldNames) ? "," + fieldNames : "") + " list:1"));
        }
    }
}

