package cn.schoolwow.ams.config;

import cn.schoolwow.ams.listener.AMSListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;

@Configuration
public class QuickAMSWebMvcConfig extends WebMvcConfigurerAdapter {
    @Autowired(required = false)
    private List<AMSListener> amsListenerList;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        for(AMSListener amsListener:amsListenerList){
            registry.addResourceHandler("/"+amsListener.projectName()+"/**")
                    .addResourceLocations("classpath:/static/");
        }
    }
}
