package cn.schoolwow.ams.flow.block;

import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class AddDatabaseEntityBlockFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        changeTimeSort(flowContext);
        setResourceFields(flowContext);
    }

    @Override
    public String name() {
        return "添加数据库表区块";
    }

    private void changeTimeSort(FlowContext flowContext){
        Entity entity = (Entity) flowContext.checkData("entity");

        //修改创建时间和更新时间的位置
        List<Property> propertyList = entity.properties;
        List<Property> propertyList1 = new ArrayList<>(propertyList);
        propertyList1.removeIf(property -> property.column.equalsIgnoreCase("created_at")||property.column.equalsIgnoreCase("updated_at"));
        {
            Property createAtProperty = entity.getPropertyByFieldNameOrColumnName("created_at");
            if(null!=createAtProperty){
                createAtProperty.comment = "创建时间";
                propertyList1.add(createAtProperty);
            }
        }
        {
            Property updateAtProperty = entity.getPropertyByFieldNameOrColumnName("updated_at");
            if(null!=updateAtProperty){
                updateAtProperty.comment = "更新时间";
                propertyList1.add(updateAtProperty);
            }
        }
        entity.properties.clear();
        entity.properties.addAll(propertyList1);
    }

    private void setResourceFields(FlowContext flowContext){
        JSONObject block = (JSONObject) flowContext.checkData("block");
        String daoName = (String) flowContext.checkData("daoName");
        Entity entity = (Entity) flowContext.checkData("entity");

        block.put("daoName", daoName);
        block.put("tableName", entity.tableName);

        List<Property> propertyList = entity.properties;
        JSONObject resourceFields = new JSONObject(true);
        JSONObject operationFields = new JSONObject(true);
        for (Property property : propertyList) {
            if (!property.column.equalsIgnoreCase("id") && property.comment.isEmpty()) {
                continue;
            }
            JSONObject field = new JSONObject();
            if (property.column.equalsIgnoreCase("id")) {
                property.comment = "id";
            }
            //判断是否下拉选择
            if (property.comment.contains("(")) {
                setSolidSelectField(entity, property, field);
            } else {
                setBasicField(property, field);
            }
            String label = StringUtil.underline2Camel(property.column);
            resourceFields.put(label, field);

            JSONObject operation = new JSONObject();
            operation.put("slot", "searchs");
            operation.put("type", "field");
            operation.put("label", field.getString("label"));
            operation.put("field", field);
            operationFields.put(label, operation);
        }
        block.put("resourceFields", resourceFields);
        block.put("operationFields", operationFields);
    }

    private void setSolidSelectField(Entity entity, Property property, JSONObject field){
        String comment = property.comment.substring(0, property.comment.indexOf("("));
        field.put("label", comment);
        field.put("info", "请选择" + comment);
        field.put("type", "select");

        JSONObject props = new JSONObject();
        field.put("props", props);
        props.put("placeholder", "请选择" + comment);
        props.put("clearable", true);
        props.put("multiple", false);

        JSONObject options = new JSONObject();
        props.put("options", options);

        String selectText = property.comment.substring(property.comment.indexOf("(") + 1, property.comment.indexOf(")"));
        String[] tokens = selectText.split(",");
        for (String token : tokens) {
            int indexOf = token.indexOf(":");
            if (indexOf < 0) {
                throw new IllegalArgumentException("实体类注释异常!表名:" + entity.tableName + ",字段名:" + property.name + ",注释:" + property.comment);
            }
            String key = token.substring(0, indexOf);
            String value = token.substring(indexOf + 1);
            options.put(key, value + "(" + key + ")");
        }
    }

    private void setBasicField(Property property, JSONObject field){
        field.put("label", property.comment);
        field.put("info", property.comment);
        if (property.columnType.contains("date") || property.columnType.contains("timestamp")) {
            field.put("type", "datetime");
        } else if(property.comment.startsWith("是否")){
            field.put("type", "switch");
        }else if(property.column.contains("url")){
            field.put("type", "link");
        }else{
            field.put("type", "text");
        }

        JSONObject props = new JSONObject();
        field.put("props", props);
        props.put("placeholder", "请输入" + property.comment);
    }
}
