let blockNameMap = {};
function handleRoute(routes){
    for(let i=0;i<routes.length;i++){
        let route = routes[i];
        route["meta"] = {
            "icon": "el-icon-menu"
        };
        if(route.hasOwnProperty("block")){
            continue;
        }
        if(!route.hasOwnProperty("children")){
            let blockName = route["path"].substring(1)+"|listBlock";
            if(blockExists(blockName)){
                route["block"] = blockName;
            }else{
                route["block"] = route["path"].substring(1);
            }
            blockNameMap[blockName] = route["name"];
        }else{
            handleRoute(route["children"]);
        }
    }
}

function blockExists(blockName){
    if(ams.blocks.hasOwnProperty(blockName)){
        return true;
    }
    return false;
}

function loadRouterBlock(){
    handleRoute(routes);

    let routerBlock = {
        "type": "router",
        "router": {
            "defaultBreadcrumb": false,
            "routes": routes
        },
        "on": {
            beforeEach(to, from, next){
                for(let prop in ams.blocks){
                    let block = ams.blocks[prop];
                    if(block["type"]==="list"&&block.hasOwnProperty("actions")){
                        if(block["actions"].hasOwnProperty("cancelListen")&&from["name"]===blockNameMap[prop]){
                            ams.callAction(prop+".cancelListen");
                        }
                    }
                }
                next();
            },
        }
    };
    if(window.hasOwnProperty("routerBlockConfig")){
        let routerBlockConfig = window["routerBlockConfig"];
        Object.assign(routerBlock, routerBlockConfig);
    }
    ams.block("routerBlock", routerBlock);
}