/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.AddBlockItemDialogOption;
import cn.schoolwow.ams.domain.EditBlockItemDialogOption;
import cn.schoolwow.ams.listener.AMSTableConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetAMSTableConfigFlow
implements BusinessFlow {
    @Autowired(required=false)
    private List<AMSTableConfig> amsTableLConfigList;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if (null == this.amsTableLConfigList || this.amsTableLConfigList.isEmpty()) {
            return;
        }
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        for (AMSTableConfig amsTableLConfig : this.amsTableLConfigList) {
            for (int i = 0; i < blocks.size(); ++i) {
                JSONObject block = blocks.getJSONObject(i);
                if (!amsTableLConfig.projectName().equals(block.getString("projectName")) || !amsTableLConfig.daoName().equals(block.getString("daoName")) || !amsTableLConfig.tableName().equals(block.getString("tableName"))) continue;
                Validate.notEmpty((CharSequence)amsTableLConfig.name(), (String)("\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!\u7c7b\u540d:" + amsTableLConfig.getClass().getName()), (Object[])new Object[0]);
                JSONObject itemDialog = new JSONObject();
                if (this.setAddButton(amsTableLConfig, block)) {
                    itemDialog.put("addBlockItemDialogOption", (Object)amsTableLConfig.getAddBlockItemDialogOption());
                }
                if (this.setUpdateButton(amsTableLConfig, block)) {
                    itemDialog.put("editBlockItemDialogOption", (Object)amsTableLConfig.getEditBlockItemDialogOption());
                }
                this.setDeleteButton(amsTableLConfig, block);
                block.put("itemDialog", (Object)itemDialog);
            }
        }
    }

    public String name() {
        return "\u914d\u7f6e\u5217\u8868\u589e\u5220\u6539\u6309\u94ae";
    }

    private boolean setAddButton(AMSTableConfig amsTableLConfig, JSONObject block) {
        AddBlockItemDialogOption addBlockItemDialogOption = amsTableLConfig.getAddBlockItemDialogOption();
        if (null == addBlockItemDialogOption) {
            return false;
        }
        Object[] addFieldNameList = addBlockItemDialogOption.addFieldNameList;
        Validate.notEmpty((Object[])addFieldNameList, (String)("\u5f85\u6dfb\u52a0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!\u7c7b\u540d:" + amsTableLConfig.getClass().getName()), (Object[])new Object[0]);
        if (!block.containsKey((Object)"operationFields")) {
            block.put("operationFields", (Object)new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        operationField.put("type", (Object)"button");
        operationField.put("slot", (Object)"rightTop");
        operationField.put("label", (Object)("\u65b0\u589e" + amsTableLConfig.name()));
        JSONObject props = new JSONObject();
        props.put("type", (Object)"primary");
        operationField.put("props", (Object)props);
        operationField.put("event", (Object)"addBlockItemDialog list:1");
        operationFields.put("addBlockItemDialogButton", (Object)operationField);
        return true;
    }

    private boolean setUpdateButton(AMSTableConfig amsTableLConfig, JSONObject block) {
        EditBlockItemDialogOption editBlockItemDialogOption = amsTableLConfig.getEditBlockItemDialogOption();
        if (null == editBlockItemDialogOption) {
            return false;
        }
        if (!block.containsKey((Object)"operationFields")) {
            block.put("operationFields", (Object)new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        operationField.put("type", (Object)"button");
        operationField.put("label", (Object)"\u66f4\u65b0");
        JSONObject props = new JSONObject();
        props.put("type", (Object)"warning");
        operationField.put("props", (Object)props);
        operationField.put("event", (Object)"editBlockItemDialog list:1");
        operationFields.put("editShopSupplyItemDialogButton", (Object)operationField);
        return true;
    }

    private void setDeleteButton(AMSTableConfig amsTableLConfig, JSONObject block) {
        String deleteField = amsTableLConfig.getDeleteField();
        if (null == deleteField || deleteField.isEmpty()) {
            return;
        }
        if (!block.containsKey((Object)"operationFields")) {
            block.put("operationFields", (Object)new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        operationField.put("type", (Object)"button");
        operationField.put("label", (Object)"\u5220\u9664");
        JSONObject props = new JSONObject();
        props.put("type", (Object)"danger");
        operationField.put("props", (Object)props);
        operationField.put("event", (Object)("confirm:\u786e\u8ba4\u5220\u9664\u5417? deleteRecord:" + deleteField + " list:1"));
        operationFields.put("deleteButton", (Object)operationField);
        operationField = new JSONObject();
        operationField.put("slot", (Object)"multipleSelect");
        operationField.put("type", (Object)"button");
        operationField.put("label", (Object)"\u6279\u91cf\u5220\u9664");
        props = new JSONObject();
        props.put("type", (Object)"danger");
        operationField.put("props", (Object)props);
        operationField.put("event", (Object)("confirm:\u786e\u8ba4\u6279\u91cf\u5220\u9664\u5417? deleteRecord:" + deleteField + " list:1"));
        operationFields.put("multipleDeleteButton", (Object)operationField);
    }
}

