package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.flow.initial.GetConfigFlow;
import cn.schoolwow.ams.flow.initial.RefreshExtraDataFlow;
import cn.schoolwow.ams.listener.AMSGlobalConfig;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.ams.service.DefaultAMSDispatcherService;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ams")
public class AMSController {
    @Resource
    private QuickFlow amsFlow;

    @Autowired(required = false)
    private AMSGlobalConfig amsGlobalConfig;

    @Resource
    private List<AMSListener> amsListenerList;

    @Resource
    private ApplicationContext applicationContext;

    @Autowired(required = false)
    private AMSDispatcherService amsDispatcherService;

    @PostConstruct
    public void postConstruct(){
        if(null==amsDispatcherService){
            amsDispatcherService = new DefaultAMSDispatcherService(amsFlow);
        }
    }

    @RequestMapping("/config")
    public JSONObject config(
            @RequestParam(value = "projectName", required = false) String projectName
    ) {
        if(null==projectName||projectName.isEmpty()){
            projectName = getDefaultProjectName();
        }
        FlowContext flowContext = amsFlow.startFlow(applicationContext.getBean(GetConfigFlow.class))
                .putCurrentCompositeFlowData("projectName", projectName)
                .execute();
        JSONObject config = (JSONObject) flowContext.checkData("config");
        return config;
    }

    @RequestMapping("/refreshExtraData")
    public JSONObject refreshExtraData(
            @RequestParam(value = "projectName", required = false) String projectName
    ) {
        if(null==projectName||projectName.isEmpty()){
            projectName = getDefaultProjectName();
        }
        FlowContext flowContext = amsFlow.startFlow(applicationContext.getBean(RefreshExtraDataFlow.class))
                .putCurrentCompositeFlowData("projectName", projectName)
                .execute();
        JSONObject extraData = (JSONObject) flowContext.getData("extraData");
        return extraData;
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/list")
    public JSONObject list(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        return amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/create")
    public void create(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject createEntity
    ) throws Exception {
        amsDispatcherService.create(projectName, daoName, tableName, createEntity);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/edit")
    public void edit(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject updateEntity
    ) throws Exception {
        amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/delete")
    public void delete(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
    }

    @RequestMapping("/api/{projectName}/{daoName}/{tableName}/{methodName}")
    public JSONObject operationDispatcher(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @PathVariable("methodName") String methodName,
            @RequestBody(required = false) JSONObject requestBody
    ) throws Exception {
        return amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
    }

    @RequestMapping("/api/{projectName}/remoteSelect/{type}")
    public JSONArray remoteSelect(
            @PathVariable("projectName") String projectName,
            @PathVariable("type") String type,
            @RequestParam(required = false) Map<String, String> amsRemoteSelectMap
    ) throws Exception {
        return amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
    }

    private String getDefaultProjectName(){
        if(null!=amsGlobalConfig){
            return amsGlobalConfig.defaultProjectName();
        }else if(amsListenerList.size()==1){
            return amsListenerList.get(0).projectName();
        }else{
            throw new IllegalArgumentException("未配置AMSGlobalConfig对象或者ams项目大于1个!ams项目个数:"+amsListenerList.size());
        }
    }
}
