package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSTableListener;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

public class ListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        if("clazz".equalsIgnoreCase(daoName)){
            getByClazz(flowContext);
        }else{
            getByTable(flowContext);
        }
    }

    @Override
    public String name() {
        return "list操作";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        AMSListListener amsListListener = (AMSListListener) flowContext.checkData("amsListListener");
        AMSTableListener amsTableListener = (AMSTableListener) flowContext.getData("amsTableListener");

        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListListener.getDAO(daoName);
        Entity entity = dao.getEntity(tableName);
        Condition condition;
        if(null==entity){
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for(Property property:entity.properties){
                condition.addColumn(property.column + " " + StringUtil.underline2Camel(property.column));
            }
        }else{
            condition = dao.query(entity.clazz);
        }
        if(null!=amsTableListener){
            amsTableListener.beforeExecuteCondition(condition, amsListCondition);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        PageVo pageVo = condition.execute().getPagingList();
        if(null!=amsTableListener){
            amsTableListener.afterExecuteCondition(condition, amsListCondition, pageVo);
        }
        JSONObject amsPagingList = AMSUtil.getAMSPagingList(pageVo);
        flowContext.putData("amsPagingList", amsPagingList);
    }

    private void getByClazz(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        JSONArray amsClazzListenerArray = (JSONArray) flowContext.getData("amsClazzListenerArray", new JSONArray());

        for(int i=0;i<amsClazzListenerArray.size();i++){
            JSONObject o = amsClazzListenerArray.getJSONObject(i);

            if(!o.containsKey("list")){
                continue;
            }
            if(!projectName.equalsIgnoreCase(o.getString("projectName"))){
                continue;
            }
            if(!tableName.equalsIgnoreCase(o.getString("className"))){
                continue;
            }
            ListClazzListener listClazzListener = (ListClazzListener) o.get("list");
            JSONObject amsPagingList = listClazzListener.list(amsListConditionMap);
            flowContext.putData("amsPagingList", amsPagingList);
            return;
        }
        throw new IllegalArgumentException("未匹配到Clazz选项!方法:List,项目名:"+projectName+",类型:"+tableName);
    }
}
