package cn.schoolwow.ams.flow.dispatcher.common;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Collection;

public class SetAMSListListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        Collection<AMSListListener> amsListListenerList = (Collection<AMSListListener>) flowContext.checkData("amsListListenerList");

        for(AMSListListener amsListListener:amsListListenerList){
            if(projectName.equalsIgnoreCase(amsListListener.projectName())){
                flowContext.putTemporaryData("amsListListener", amsListListener);
                break;
            }
        }
    }

    @Override
    public String name() {
        return "根据项目名设置amsListListener";
    }
}
