package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.listener.AMSClazzListenerAware;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class InitialAwareListFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSClazzListenerAware> amsClazzListenerAwareList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setAMSClazzListenerList(flowContext);
    }

    @Override
    public String name() {
        return "初始化aware接口";
    }

    private void setAMSClazzListenerList(FlowContext flowContext){
        if(null==amsClazzListenerAwareList||amsClazzListenerAwareList.isEmpty()){
            return;
        }
        JSONArray amsClazzListenerArray = new JSONArray();
        for(AMSClazzListenerAware amsClazzListenerAware:amsClazzListenerAwareList){
            List<AMSClazzListener> amsClazzListenerList = amsClazzListenerAware.getAMSClazzListener();
            for(AMSClazzListener amsClazzListener:amsClazzListenerList){
                JSONObject listener = amsClazzListener.getListener();
                Validate.notEmpty(listener.getString("projectName"), "项目名不能为空!涉及类名:"+amsClazzListenerAware.getClass().getName());
                Validate.notEmpty(listener.getString("className"), "实体类名不能为空!涉及类名:"+amsClazzListenerAware.getClass().getName());
                amsClazzListenerArray.add(listener);
            }
        }
        flowContext.putContextData("amsClazzListenerArray", amsClazzListenerArray);
    }
}
