package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.listener.AMSRemoteSelect;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetAMSRemoteSelectFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSRemoteSelect> amsRemoteSelectList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if(null==amsRemoteSelectList||amsRemoteSelectList.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(AMSRemoteSelect amsRemoteSelect:amsRemoteSelectList){
            String[] uniqueKeyFieldArray = amsRemoteSelect.uniqueKeyFieldArray();
            if(null==uniqueKeyFieldArray||uniqueKeyFieldArray.length==0){
                continue;
            }
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                String uniqueKey = block.getString("uniqueKey");
                for(String uniqueKeyField:uniqueKeyFieldArray){
                    if(uniqueKeyField.startsWith(uniqueKey)){
                        String[] tokens = uniqueKeyField.split("\\|", -1);
                        String projectName = tokens[0];
                        String fieldName = tokens[3];
                        String comment = tokens[4];
                        String parameter = tokens.length>=6?tokens[5]:null;
                        if(!block.containsKey("operationFields")){
                            block.put("operationFields", new JSONObject(true));
                        }
                        JSONObject operationFields = block.getJSONObject("operationFields");
                        if(!operationFields.containsKey(fieldName)){
                            operationFields.put(fieldName, new JSONObject());
                        }
                        JSONObject operationField = operationFields.getJSONObject(fieldName);
                        setRemoteSelectOperation(projectName, comment, parameter, amsRemoteSelect.type(), operationField);
                    }
                }
            }
        }
    }

    @Override
    public String name() {
        return "设置远程下拉框";
    }

    private void setRemoteSelectOperation(String projectName, String comment, String parameter, String type, JSONObject operationField){
        operationField.put("slot", "searchs");
        operationField.put("type", "field");
        operationField.put("label", comment);

        {
            JSONObject field = new JSONObject();
            field.put("BASE", "SELECT_REMOTE");
            field.put("type", "select");
            field.put("info", comment);
            {
                JSONObject props = new JSONObject();
                props.put("placeholder", "请选择"+comment);
                props.put("clearable", true);
                props.put("multiple", false);
                field.put("props", props);
            }
            {
                JSONObject remoteConfig = new JSONObject();
                remoteConfig.put("dataPath", "data");
                remoteConfig.put("action", "/ams/api/"+projectName+"/remoteSelect/"+type+(StringUtils.isNotBlank(parameter)?"?"+parameter:""));
                remoteConfig.put("queryKey", "name");
                remoteConfig.put("isCache", false);
                field.put("remoteConfig", remoteConfig);
            }
            operationField.put("field", field);
        }
    }
}
