package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.block.ListBlock;
import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetBlockUniqueKeyFlow implements BusinessFlow {
    @Autowired
    private List<AMSListListener> amsListListenerList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());
        for(AMSListListener amsListListener:amsListListenerList){
            List<ListBlock> listBlocks = amsListListener.initialListBlocks();
            for(ListBlock listBlock:listBlocks){
                blocks.add(listBlock.getBlock());
            }

            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                if(!block.containsKey("projectName")){
                    block.put("projectName", amsListListener.projectName());
                }
            }
            for(int i=0;i<blocks.size();i++){
                JSONObject block = blocks.getJSONObject(i);
                Validate.notEmpty(block.getString("projectName"), "block项目名不能为空");
                Validate.notEmpty(block.getString("daoName"), "block数据库名不能为空");
                Validate.notEmpty(block.getString("tableName"), "block表名不能为空");

                String uniqueKey = block.getString("projectName")+"|"+block.getString("daoName")+"|"+block.getString("tableName");
                block.put("uniqueKey", uniqueKey);
                block.put("resourceName", uniqueKey+"|resource");
                block.put("listBlockName", uniqueKey+"|listBlock");
            }
        }
    }

    @Override
    public String name() {
        return "设置List唯一标识";
    }
}
