package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class SetListBlockUniqueKeyFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsListBlockArray = (JSONArray) flowContext.getData("amsListBlockArray", new JSONArray());
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<amsListBlockArray.size();i++){
            JSONObject amsListBlock = amsListBlockArray.getJSONObject(i);

            String uniqueKey = amsListBlock.getString("projectName")+"|"+amsListBlock.getString("daoName")+"|"+amsListBlock.getString("tableName");
            amsListBlock.put("uniqueKey", uniqueKey);
            amsListBlock.put("resourceName", uniqueKey+"|resource");
            amsListBlock.put("listBlockName", uniqueKey+"|listBlock");

            blocks.add(amsListBlock);
        }
        flowContext.putTemporaryData("blocks", blocks);
    }

    @Override
    public String name() {
        return "设置ListBlock唯一标识";
    }
}
