package cn.schoolwow.ams.domain.listener.dialog;

import com.alibaba.fastjson.JSONObject;

public class AMSDialog {
    private JSONObject listener = new JSONObject();

    /**
     * 设置项目名
     * */
    public AMSDialog projectName(String projectName){
        listener.put("projectName", projectName);
        return this;
    }

    /**
     * 数据库名
     * */
    public AMSDialog daoName(String daoName){
        listener.put("daoName", daoName);
        return this;
    }

    /**
     * 表名
     * */
    public AMSDialog tableName(String tableName){
        listener.put("tableName", tableName);
        return this;
    }

    /**
     * 按钮名称
     * */
    public AMSDialog name(String name){
        listener.put("name", name);
        return this;
    }

    /**
     * 新增记录弹窗
     * */
    public AMSDialog addBlockItemDialogOption(AddBlockItemDialogOption addBlockItemDialogOption){
        listener.put("addBlockItemDialogOption", addBlockItemDialogOption);
        return this;
    }

    /**
     * 更新记录弹窗
     * */
    public AMSDialog editBlockItemDialogOption(EditBlockItemDialogOption editBlockItemDialogOption){
        listener.put("editBlockItemDialogOption", editBlockItemDialogOption);
        return this;
    }

    /**
     * 设置删除字段
     * */
    public AMSDialog setDeleteField(String deleteField){
        listener.put("deleteField", deleteField);
        return this;
    }

    /**
     * 设置json格式的字段名称列表
     * */
    public AMSDialog jsonFieldNameList(String... jsonFieldNameList){
        listener.put("jsonFieldNameList", jsonFieldNameList);
        return this;
    }

    public JSONObject getListener(){
        return listener;
    }
}
